package com.dst.slms.contractmange.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.contractmange.entity.EconTermsAdjustInfo;
import com.dst.slms.contractmange.entity.PaymentReqInfo;
import com.dst.slms.contractmange.entity.SaleConEconomicsInfo;
import com.dst.slms.contractmange.entity.SaleContractInfo;
import com.dst.slms.contractmange.service.IEconTermsAdjustService;
import com.dst.slms.supplierprofile.entity.SupplierProfileInfo;
import com.dst.slms.system.entity.SysOrgInfo;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dst.slms.base.entity.MarketProjectInfo;
import com.dst.slms.common.annotation.SysPermissionName;
import org.springframework.web.bind.annotation.PostMapping;
/**   
 * @Title: 经济条款调整单 Controller
 * @Description: 经济条款调整单
 * @author 
 * @date 2020-05-03 14:36:19
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/econTermsAdjustController")
@SysPermissionName(name="经济条款调整单",type=Constant.MENU)
public class EconTermsAdjustController extends AbstractEconTermsAdjustController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(EconTermsAdjustController.class);
	
	@Autowired
	private IEconTermsAdjustService iEconTermsAdjustService;
	
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("Ect:EconTermsAdjust:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(EconTermsAdjustInfo info, HttpServletRequest req) {
		return iEconTermsAdjustService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("Ect:EconTermsAdjust:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(EconTermsAdjustInfo info, HttpServletRequest req) {
		return iEconTermsAdjustService.unAudit(info.getId());
	}
	
	/**
	 * 获取合同关联信息
	 * @param info
	 * @param req
	 * @return
	 */
	@ResponseBody
    @PostMapping(value = "/getContractInfo")
	public JSONObject getContractInfo(HttpServletRequest request){
		String contractid = request.getParameter("contractid");
		JSONObject json = new JSONObject();
		if(UIRuleUtil.isNotNull(contractid)){
			SaleContractInfo contract = iEconTermsAdjustService.getEntity(SaleContractInfo.class, contractid);
			List<SaleConEconomicsInfo> list = contract.getSaleConEconomics();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			JSONArray entry = new JSONArray();
			try {
				EntityQuery eq = new EntityQuery(PaymentReqInfo.class);
				eq.eq("contract.id", contractid);
				eq.eq("state", "AUDIT");
				eq.add();
				List entityList = iEconTermsAdjustService.getEntityList(eq);
				for (int i = 0; i < entityList.size(); i++) {
					JSONObject estdata =  new JSONObject();
					PaymentReqInfo payReqInfo = (PaymentReqInfo) entityList.get(i);
					BigDecimal taxReqAmt = UIRuleUtil.getBigDecimal(payReqInfo.getTaxReqAmt());
					BigDecimal contractAmt = UIRuleUtil.getBigDecimal(payReqInfo.getContractAmt());
					BigDecimal rate = taxReqAmt.divide(contractAmt);
					estdata.put("bizDate", payReqInfo.getBizDate());
					estdata.put("payType", payReqInfo.getPayType());
					estdata.put("pay", "实付款");
					estdata.put("payScale", rate.multiply(new BigDecimal(100)));
					estdata.put("payAmt", BigDecimal.ZERO);
					estdata.put("amount", payReqInfo.getTaxReqAmt());
					entry.add(estdata);
				}
				
				Date sysDate = sdf.parse(sdf.format(new Date()));
				for (int i = 0; i < list.size(); i++) {
					JSONObject estdata =  new JSONObject();
					SaleConEconomicsInfo economicsInfo = list.get(i);
					Date bizDate = economicsInfo.getBizDate();
					String forbizDate = sdf.format(bizDate);
					bizDate = sdf.parse(forbizDate);
					if(bizDate.getTime()>=sysDate.getTime()){
						estdata.put("bizDate", bizDate);
						estdata.put("payType", economicsInfo.getPayType());
						estdata.put("pay", economicsInfo.getPay());
						estdata.put("payScale", economicsInfo.getPayScale());
						estdata.put("payAmt", economicsInfo.getPayAmt());
						estdata.put("amount", BigDecimal.ZERO);
						entry.add(estdata);
					}
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
			SupplierProfileInfo supplier = contract.getSupplier();
			MarketProjectInfo project = contract.getProject();
			SysOrgInfo orgunit = contract.getOrgunit();
			BigDecimal taxConAmt = contract.getTaxConAmt();
			json.put("supplier", supplier);
			json.put("project", project);
			json.put("orgunit", orgunit);
			json.put("taxConAmt", taxConAmt);
			json.put("entry", entry);
		}
		return json;
	}
}
