package com.dst.slms.contractmange.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.contractmange.entity.SaleContractInfo;
import com.dst.slms.contractmange.service.ISaleContractService;

/**   
 * 营销合同 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 营销合同
 * @author 
 * @date 2020-05-02 17:43:18
 * @version V1.0   
 *
 */
public abstract class AbstractSaleContractController extends CoreBaseController {

	@Autowired
	private ISaleContractService iSaleContractService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/contractmange/salecontract/saleContractList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/contractmange/salecontract/saleContractEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSaleContractService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SaleContractInfo info = new SaleContractInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("orgunit.id");
		sic.add("orgunit.number");
		sic.add("orgunit.name");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("contractType.id");
		sic.add("contractType.number");
		sic.add("contractType.name");
		sic.add("partA.id");
		sic.add("partA.number");
		sic.add("partA.name");
		sic.add("kjcontract.id");
		sic.add("kjcontract.number");
		sic.add("kjcontract.name");
		sic.add("saleConNature");
		sic.add("projectApprove.id");
		sic.add("projectApprove.number");
		sic.add("projectApprove.name");
		sic.add("isSettlement");
		sic.add("settlementAmt");
		sic.add("dutyDep.id");
		sic.add("dutyDep.number");
		sic.add("dutyDep.name");
		sic.add("signDate");
		sic.add("dutyPerson.id");
		sic.add("dutyPerson.number");
		sic.add("dutyPerson.name");
		sic.add("lxAmt");
		sic.add("bizdate");
		sic.add("markAccount.id");
		sic.add("markAccount.number");
		sic.add("markAccount.name");
		sic.add("taxConAmt");
		sic.add("tax");
		sic.add("notaxConAmt");
		sic.add("taxAmt");
		sic.add("supplier.id");
		sic.add("supplier.number");
		sic.add("supplier.name");
		sic.add("saleContractTaxE.parent.id");
		sic.add("saleContractTaxE.parent.number");
		sic.add("saleContractTaxE.parent.name");
		sic.add("saleContractTaxE.content");
		sic.add("saleContractTaxE.taxConAmt");
		sic.add("saleContractTaxE.taxRate.id");
		sic.add("saleContractTaxE.taxRate.number");
		sic.add("saleContractTaxE.taxRate.name");
		sic.add("saleContractTaxE.noTaxConAmt");
		sic.add("saleContractTaxE.taxAmt");
		sic.add("saleConEconomics.parent.id");
		sic.add("saleConEconomics.parent.number");
		sic.add("saleConEconomics.parent.name");
		sic.add("saleConEconomics.bizDate");
		sic.add("saleConEconomics.payType.id");
		sic.add("saleConEconomics.payType.number");
		sic.add("saleConEconomics.payType.name");
		sic.add("saleConEconomics.pay");
		sic.add("saleConEconomics.payScale");
		sic.add("saleConEconomics.payAmt");
		sic.add("saleConEconomics.remark");
		return sic;
	}

	@RequiresPermissions("sat:saleContract:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SaleContractInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("sat:saleContract:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("sat:saleContract:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("sat:saleContract:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SaleContractInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("sat:saleContract:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SaleContractInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("sat:saleContract:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SaleContractInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("sat:saleContract:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SaleContractInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("sat:saleContract:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SaleContractInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("sat:saleContract:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(SaleContractInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
