package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 投放分录 Info 对象
 * @Description: 投放分录
 * @author 
 * @date 2020-05-04 14:11:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractReceiptE2Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.ReceiptInfo parent;
	
	/**投放名称*/
	@Column(name ="Fname")
	@FieldMeta(name="投放名称" )
	private java.lang.String name;
	
	/**媒体大类*/
	@Column(name ="FMTDL")
	@FieldMeta(name="媒体大类" )
	private java.lang.String MTDL;
	
	/**媒体小类*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FMTXLID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="媒体小类" )
	private com.dst.slms.base.entity.MediaInfoInfo MTXL;
	
	/**投放起始日期*/
	@Column(name ="FstartDate")
	@FieldMeta(name="投放起始日期" )
	private java.util.Date startDate;
	
	/**结束日期*/
	@Column(name ="FendDate")
	@FieldMeta(name="结束日期" )
	private java.util.Date endDate;
	
	/**投放费用*/
	@Column(name ="FtfAmt")
	@FieldMeta(name="投放费用" )
	private java.math.BigDecimal tfAmt;
	
	/**说明*/
	@Column(name ="Fremark")
	@FieldMeta(name="说明" )
	private java.lang.String remark;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.ReceiptInfo
	 *@return: com.dst.slms.contractmange.entity.ReceiptInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.ReceiptInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.ReceiptInfo
	 *@param: com.dst.slms.contractmange.entity.ReceiptInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.ReceiptInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  投放名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  投放名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  媒体大类
	 */
	public java.lang.String getMTDL(){
		return this.MTDL;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  媒体大类
	 */
	public void setMTDL(java.lang.String MTDL){
		this.MTDL = MTDL;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MediaInfoInfo
	 *@return: com.dst.slms.base.entity.MediaInfoInfo  媒体小类
	 */
	public com.dst.slms.base.entity.MediaInfoInfo getMTXL(){
		return this.MTXL;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MediaInfoInfo
	 *@param: com.dst.slms.base.entity.MediaInfoInfo  媒体小类
	 */
	public void setMTXL(com.dst.slms.base.entity.MediaInfoInfo MTXL){
		this.MTXL = MTXL;
	}
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  投放起始日期
	 */
	public java.util.Date getStartDate(){
		return this.startDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  投放起始日期
	 */
	public void setStartDate(java.util.Date startDate){
		this.startDate = startDate;
	}
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  结束日期
	 */
	public java.util.Date getEndDate(){
		return this.endDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  结束日期
	 */
	public void setEndDate(java.util.Date endDate){
		this.endDate = endDate;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  投放费用
	 */
	public java.math.BigDecimal getTfAmt(){
		return this.tfAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  投放费用
	 */
	public void setTfAmt(java.math.BigDecimal tfAmt){
		this.tfAmt = tfAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemark(){
		return this.remark;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemark(java.lang.String remark){
		this.remark = remark;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "H38HOS98";
	}
}
