package com.dst.slms.base.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.entity.CoreInfo;
import com.dst.slms.common.entity.TreeBaseInfo;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.system.entity.SysOrgInfo;
import com.dst.slms.system.service.ISysOrgService;
import com.dst.slms.base.entity.MarketAccountInfo;
import com.dst.slms.base.service.IMarketAccountService;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 营销科目 Controller
 * @Description: 营销科目
 * @author 
 * @date 2020-05-02 10:08:28
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/marketAccountController")
@SysPermissionName(name="营销科目",type=Constant.MENU)
public class MarketAccountController extends AbstractMarketAccountController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(MarketAccountController.class);

	@Autowired
	private IMarketAccountService iMarketAccountService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(MarketAccountInfo info, HttpServletRequest req) {
		return iMarketAccountService.changeEnable(info,req);
	}
	
	@Override
	public TreeBaseInfo getTreeBaseInfo() {
		return new MarketAccountInfo();
	}
	
	@Override
	protected boolean isIgnoreCUFilter() {
		return true;
	}
	
	@Override
	public EntityQuery getQueryExecutor(HttpServletRequest request, CoreInfo info, DataGrid dataGrid) {
		EntityQuery queryExecutor = super.getQueryExecutor(request, info, dataGrid);
		//选中左边树节点ID
		String selectTreeId = request.getParameter("selectTreeId");
		 
		if(UIRuleUtil.isNotNull(selectTreeId)){
			SelectorItemCollection sic = new SelectorItemCollection();
			sic.add("longNumber");
			MarketAccountInfo accountInfo = (MarketAccountInfo) getService().getEntity(MarketAccountInfo.class, selectTreeId,sic);
			queryExecutor.like("longNumber", accountInfo.getLongNumber()+"%");
		}
		queryExecutor.add();
		
		return queryExecutor;
	
	}
	
	@Override
	public Object createNewModel(HttpServletRequest req) {
		String selectTreeId = req.getParameter("selectTreeId");
		MarketAccountInfo createNewModel = (MarketAccountInfo) super.createNewModel(req);
		if(UIRuleUtil.isNotNull(selectTreeId)){
			MarketAccountInfo accountInfo = (MarketAccountInfo) getService().getEntity(MarketAccountInfo.class, selectTreeId);
			createNewModel.setParent(accountInfo);
		}
		return createNewModel;
	}
	
	/**
	 * 动态加载营销科目树
	 * @param typeGroupName
	 * @return
	 */
	@ResponseBody
    @RequestMapping(value = "/getAccountTreeData")
	public List getAccountTreeData(HttpServletRequest request) {
		return iMarketAccountService.getAccountTreeData(request);
	}
	
}
