<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/common/common.jsp"%>
<head>
<Dst:SMBase type="jquery,eui" pakgagePath="com.dst.slms.plan.cyclepaymentplan.cyclePaymentPlanEdit" uipk="cyclePaymentPlanController" title="项目全周期费用规划"/>
</head>
<body class="dst-mainbackground">
<div class="dst-container">

<Dst:SMMain title="项目全周期费用规划">
	<Dst:SMEDBillToolBar >
	   <Dst:SMDGToolBar title="保存" icon="fa fa-save" bindAction="saveAction"/>
	   <Dst:SMDGToolBar title="提交并关闭" icon="fa fa-clipboard" bindAction="submitAction"/>
	   <Dst:SMDGToolBar title="查看流程图" icon="fa fa-cubes" bindAction="viewFlowAction"/>
	   <Dst:SMDGToolBar title="关闭" icon="fa fa-rotate-left" bindAction="closeAction"/>
	</Dst:SMEDBillToolBar> 
	<Dst:SMForm formid="formobj" >
		<input id="id" name="id" type="hidden" value="${model.id }">
		<input id="oldId" name="oldId" type="hidden" value="${oldId}">
		<div class="easyui-panel" title="项目全周期费用规划<span>信息</span>" style="width:100%;" data-options="bodyCls:'panle-background',collapsible:true,headerCls:'panel-block-teal panel-description'">
			<div style="padding-top: 10px"></div>
			<div class="dst-row">
				<%-- 
				<div class="dst-col-sm4">
					<label class="dst-form-label">规划名称</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="name" validType="['maxLength[100]']" width="100%" value="${model.name}"/>
					</div>
				</div> --%>
				<div class="dst-col-sm4">
					<label class="dst-form-label">规划编号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="number" required="true" validType="['maxLength[100]']" width="100%" value="${model.number}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">项目</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="project" required="true" DSTFilter="isEnable='Y'"  queryFieldItem="number,name" entityPath="com.dst.slms.base.entity.MarketProjectInfo" width="100%" value="${model.project}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">提交人</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="person" required="true" queryFieldItem="number,name" url="/systemPop/personPage?isShowAll=true&multiSelect=false&isDcData=true" width="100%" value="${model.person}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">销售目标</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="saleTarget" required="true" precision="2" width="100%" value="${model.saleTarget}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">预算金额</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="budget" readonly="true" precision="2" width="100%" value="${model.budget}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">费率%</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="rate" readonly="true" precision="2" width="100%" value="${model.rate}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">状态</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="state" readonly="true" dicGroupCode="BILLSTATUS" width="100%" value="${model.state}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">版本号</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="editionnumber" width="100%" readonly="true" value="${model.editionnumber}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<div class="dst-input-block">
						<Dst:SMCheckBox id="isnew" label="是否最新版" readonly="true" value="${model.isnew}"/>
					</div>
				</div>
			</div>
		</div>	
		<div style="padding-top: 10px;height: 400px;">
			<%-- <Dst:SMDatagrid name="editTreeGrid" fit="true" title="科目规划" fitColumns="false" rowStyler="fmtRowStyle" treegrid="true" treegridIsSyn="false" treeField="name" actionUrl="/cyclePaymentPlanController?getAccountEntryData&id=${model.id }" idField="id" pagination="false" >
			   <Dst:SMDgCol title="id" field="id" hidden="true"></Dst:SMDgCol>
			   <Dst:SMDgCol title="科目名称" field="name" query="true" width="150"></Dst:SMDgCol> 
			   <Dst:SMDgCol title="科目编码" field="number" ></Dst:SMDgCol>
			   <Dst:SMDgCol title="规划金额*" field="planAmount"  ></Dst:SMDgCol>
			   <Dst:SMDgCol title="占比%" field="rate" width="60"></Dst:SMDgCol>
			   <Dst:SMDgCol title="已发生金额" field="yfsAmount" width="80"></Dst:SMDgCol>
			   <Dst:SMDgCol title="规划余额" field="planYe" width="80" ></Dst:SMDgCol>
			   <Dst:SMDgCol title="已支付" field="payAmount" ></Dst:SMDgCol>
			   <Dst:SMDgCol title="说明" field="remarks" width="250" ></Dst:SMDgCol>
			   <Dst:SMDGToolBar title="重新加载数据" icon="fa fa-file-o" />
			</Dst:SMDatagrid> --%>
			<table id="editTreeGrid" ></table> 
		</div>
		<%-- <Dst:SMEDDatagrid entityPath="com.dst.slms.plan.entity.CyclePaymentPlanE1Info" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
		ctrlSelect="true" title="费用明细" data="${model.cyclePaymentPlanE1}" id="cyclePaymentPlanE1" >
			<Dst:SMEDBillToolBar id="cyclePaymentPlanE1tb">
				<Dst:SMDGToolBar title="新增" icon="icon-entity-addline" bindAction="addRow"/>
				<Dst:SMDGToolBar title="删除" icon="icon-entity-deleteline" bindAction="removeRow"/>
			</Dst:SMEDBillToolBar>  
			<Dst:SMEDColumnMoreHeaderGroup>
				<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
				<Dst:SMEDColumnBizPromptBox field="parent" hidden="true" queryFieldItem="number,name" title="父对象关联" entityPath="com.dst.slms.plan.entity.CyclePaymentPlanInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnTextBox field="accountNumber" readonly="true" title="科目编码" width="100"></Dst:SMEDColumnTextBox>
				<Dst:SMEDColumnBizPromptBox field="marketAccount" readonly="true" queryFieldItem="number,name" DSTFilter="isEnable='Y'" title="费用科目" entityPath="com.dst.slms.base.entity.MarketAccountInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnNumberBox field="planAmount" title="规划金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="rate" title="占比" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="yfsAmount" title="已发生金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="planYe" title="规划余额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="payAmount" title="已支付" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnTextBox field="remarks" title="说明" width="200"></Dst:SMEDColumnTextBox>
			</Dst:SMEDColumnMoreHeaderGroup>
		</Dst:SMEDDatagrid> --%>
		<div style="padding-top: 10px"></div>
		<Dst:SMEDDatagrid entityPath="com.dst.slms.plan.entity.CyclePaymentPlanE2Info" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
		ctrlSelect="true" title="预算年度拆解" data="${model.cyclePaymentPlanE2}" id="cyclePaymentPlanE2" entry_editChange="e2_editChange" >
			<Dst:SMEDBillToolBar id="cyclePaymentPlanE2tb">
				<Dst:SMDGToolBar title="新增" icon="icon-entity-addline" bindAction="addRow"/>
				<Dst:SMDGToolBar title="删除" icon="icon-entity-deleteline" bindAction="removeRow"/>
			</Dst:SMEDBillToolBar>  
			<Dst:SMEDColumnMoreHeaderGroup>
				<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
				<Dst:SMEDColumnBizPromptBox field="parent" hidden="true" queryFieldItem="number,name" title="父对象关联" entityPath="com.dst.slms.plan.entity.CyclePaymentPlanInfo"></Dst:SMEDColumnBizPromptBox>
				<%-- <Dst:SMEDColumnEnumDicBox field="year" title="年份" dicGroupCode="year" width="100"></Dst:SMEDColumnEnumDicBox> --%>
				<Dst:SMEDColumnBizPromptBox field="year" disPlayFormatName="number" queryFieldItem="number,name" title="年份" DSTFilter="isEnable='Y'" entityPath="com.dst.slms.base.entity.SysYearInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnNumberBox field="planAmountRate" title="规划金额百分比%" precision="2" width="120"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="planAmount" readonly="true" title="规划金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="yfsAmount" readonly="true" title="已发生金额" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="payAmount" readonly="true" title="支付金额" precision="2"></Dst:SMEDColumnNumberBox>
			</Dst:SMEDColumnMoreHeaderGroup>
		</Dst:SMEDDatagrid>
	</Dst:SMForm>	
</Dst:SMMain>
</div>
<script type="text/javascript">
$(function() {
	$('#saleTarget').numberbox({    
	    onChange:function(newValue,oldValue){
			var saleTarget = newValue;      // 预算金额
			var budget = $('#budget').numberspinner('getValue');      // 预算金额
			if(saleTarget != undefined && saleTarget!=0){
				var rate = Number(budget)/Number(saleTarget);
				$("#rate").numberspinner("setValue",rate*Number(100));
			}else{
				$("#rate").numberspinner("setValue","");
			}
	    } 
	});
})
</script>
</body>
