package com.dst.slms.workBench.service.impl;

import com.dst.slms.base.service.IMarketProjectService;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.util.DateUtil;
import com.dst.slms.util.ParamEnum;
import com.dst.slms.workBench.service.ICostEffectiveService;
import com.dst.slms.workBench.service.sql.CostEffectiveSQL;
import com.dst.slms.workBench.service.sql.FeeControlSQL;
import com.google.common.collect.ImmutableMap;
import org.apache.poi.ss.formula.functions.Na;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;

@Service
@Transactional
public class ICostEffectiveServiceImpl implements ICostEffectiveService {
    @Autowired
    private IMarketProjectService iMarketProjectService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    private final static  BigDecimal tenThousand = new BigDecimal( "10000" );
    private final static  BigDecimal hundred = new BigDecimal( "100" );
    /**
     * @description  数据初始化
     * @param  projectIds  所选的项目id
     * @return  R 数据
     * @date  20/05/05 17:20
     * @author  wanghb
     * @edit  .
     */
    @Override
    public R initData(String projectIds) {
        String condition1 = "".equals( projectIds ) ? "" : " AND l1.FprojectID in ("+projectIds+") ";
        String condition2 = " AND l1.FSTATE = ? ";
        String nowYear = DateUtil.getSysYear();
        String nowMonth = DateUtil.getMonth();
        String yearMonth = DateUtil.toString( new Date(), DateUtil.YEAR_MONTH );
        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        String yes = ParamEnum.ISYN.YES.getCode();
        String marketingSubjects = ParamEnum.MarketAccount.Market1.getName();

        Map<String, Object> returnData = new HashMap<>();
        /******************************全部汇总开始******************************/
        Map<String, Object> allSummary = new HashMap<>();
        StringBuffer SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_01 );
        SQL.append( condition1 );
        SQL.append( condition2 );
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(), new String[]{ audit} );
        Map<String, Object> temp = list.size() > 0 ? list.get( 0 ) : new HashMap<>();
        //来访人数
        BigDecimal lfcount = UIRuleUtil.getBigDecimal( temp.get( "lfcount" ) );
        //成交套数
        BigDecimal cjcount = UIRuleUtil.getBigDecimal( temp.get( "cjcount" ) );
        //成交金额
        BigDecimal cjAmt = UIRuleUtil.getBigDecimal( temp.get( "cjAmt" ) );
        //营销费用
        BigDecimal ysAmt = UIRuleUtil.getBigDecimal( temp.get( "ysAmt" ) );
        //费率   营销费用/销售金额  5月8号变更为  营销费用/成交金额
        //SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_02 );
        //SQL.append( condition1 );
        //SQL.append( " AND l1.FyearMonth like '"+nowYear+"%' " );
        //BigDecimal salesAmount = UIRuleUtil.getBigDecimal( jdbcTemplate.queryForObject( SQL.toString(), String.class ) );
        BigDecimal rate = BigDecimal.ZERO.compareTo( cjAmt ) == 0 ? BigDecimal.ZERO : ysAmt.divide( cjAmt, 4, BigDecimal.ROUND_HALF_UP );
        //来访费效
        BigDecimal costEffective = BigDecimal.ZERO.compareTo( ysAmt ) == 0 ? BigDecimal.ZERO :  ysAmt.divide( lfcount, 2, BigDecimal.ROUND_HALF_UP );
        //成交费效
        BigDecimal costTransaction = BigDecimal.ZERO.compareTo( cjcount ) == 0 ? BigDecimal.ZERO : ysAmt.divide( cjcount, 2, BigDecimal.ROUND_HALF_UP );
        allSummary.put( "lfcount", lfcount );
        allSummary.put( "cjcount", cjcount );
        allSummary.put( "cjAmt", cjAmt.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP ) );
        allSummary.put( "ysAmt", ysAmt.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP ) );
        allSummary.put( "rate", rate.multiply( hundred ).setScale( 2, BigDecimal.ROUND_HALF_UP  ) );
        allSummary.put( "costEffective", costEffective );
        allSummary.put( "costTransaction", costTransaction );
        /******************************当月汇总结束******************************/

        /******************************当月汇总开始******************************/
        Map<String, Object> yearMonthSummary = new HashMap<>();
        //当月的销售目标
        SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_03 );
        SQL.append( condition1 );
        SQL.append( " AND l1.FyearMonth = ? " );
        List<Map<String, Object>> listNowMonth0 = jdbcTemplate.queryForList( SQL.toString(), new String[]{ yearMonth} );
        //销售目标
        BigDecimal salesTargetNowMonth = UIRuleUtil.getBigDecimal( listNowMonth0.get( 0 ).get( "salesTarget" ) );
        //实际销售金额
        BigDecimal salesAmountNowMonth = UIRuleUtil.getBigDecimal( listNowMonth0.get( 0 ).get( "salesAmount" ) );
        SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_01 );
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( " AND DATE_FORMAT(l1.FreqDate,'%Y-%m') = ?" );
        List<Map<String, Object>> listNowMonth = jdbcTemplate.queryForList( SQL.toString(), new String[]{ audit, yearMonth} );
        Map<String, Object> tempNowMonth = listNowMonth.size() > 0 ? listNowMonth.get( 0 ) : new HashMap<>();
        //来访计划
        BigDecimal lfcountNowMonth = UIRuleUtil.getBigDecimal( tempNowMonth.get( "lfcount" ) );
        //成交套数
        BigDecimal cjcountNowMonth = UIRuleUtil.getBigDecimal( tempNowMonth.get( "cjcount" ) );
        //成交金额
        BigDecimal cjAmtNowMonth = UIRuleUtil.getBigDecimal( tempNowMonth.get( "cjAmt" ) );
        //营销费用
        BigDecimal ysAmtNowMonth = UIRuleUtil.getBigDecimal( tempNowMonth.get( "ysAmt" ) );
        //付款申请单
        //SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_05 );
        //SQL.append( condition1 );
        //SQL.append( condition2 );
        //SQL.append( " AND DATE_FORMAT(l1.FbizDate,'%Y-%m') = ? " );
        //BigDecimal taxReqAmtNowMonth = UIRuleUtil.getBigDecimal( jdbcTemplate.queryForObject( SQL.toString(), new String[]{ audit, yearMonth}, String.class ) );
        //销售进度
        BigDecimal completionRatioNowMonth =  BigDecimal.ZERO.compareTo( salesTargetNowMonth ) == 0 ? BigDecimal.ZERO : cjAmtNowMonth.divide( salesTargetNowMonth, 4, BigDecimal.ROUND_HALF_UP );
        //费效  付款申请金额  /  成交套数  变更  验收单金额  /  成交套数
        BigDecimal costEffectiveNowMonth = BigDecimal.ZERO.compareTo( cjcountNowMonth ) == 0 ? BigDecimal.ZERO : ysAmtNowMonth.divide( cjcountNowMonth, 2, BigDecimal.ROUND_HALF_UP );
        //费用计划
        SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_06 );
        SQL.append( condition1 );
        SQL.append( " AND l1.Fyear = ? " );
        SQL.append( " AND l1.Fmonth = ? " );

        BigDecimal yearBudgetNowMonth = UIRuleUtil.getBigDecimal( jdbcTemplate.queryForObject( SQL.toString(), new String[]{ nowYear,nowMonth}, String.class ) );
        //yearBudgetNowMonth = yearBudgetNowMonth.subtract( ysAmtNowMonth );

        //费率  5月8号 费用计划/销售目标
        BigDecimal rateNowMonth = BigDecimal.ZERO.compareTo( salesTargetNowMonth ) == 0 ? BigDecimal.ZERO : yearBudgetNowMonth.multiply( hundred ).divide( salesTargetNowMonth, 2, BigDecimal.ROUND_HALF_UP );

        yearMonthSummary.put( "salesTarget", salesTargetNowMonth.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )  );
        yearMonthSummary.put( "lfcount", lfcountNowMonth );
        yearMonthSummary.put( "cjcount", cjcountNowMonth );
        yearMonthSummary.put( "cjAmt", cjAmtNowMonth.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP ) );
        yearMonthSummary.put( "rate", rateNowMonth );
        yearMonthSummary.put( "costEffective", costEffectiveNowMonth );
        yearMonthSummary.put( "completionRatio", completionRatioNowMonth.multiply( hundred ) );
        yearMonthSummary.put( "yearBudget", yearBudgetNowMonth.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP ) );
        /******************************当月汇总结束******************************/


        returnData.put( "allSummary", allSummary );
        returnData.put( "yearMonthSummary", yearMonthSummary );

        return R.ok(returnData);
    }

    /**
     * @description  表格数据初始化
     * @param  projectIds  所选的项目id
     * @return  R 数据
     * @date  20/05/05 17:20
     * @author  wanghb
     * @edit  .
     */
    @Override
    public R initEcharts(String projectIds) {
        R returnData = new R();
        initEcharts1( projectIds , returnData);
        initEcharts2( projectIds , returnData);
        initEcharts3( projectIds , returnData);
        initEcharts4( projectIds , returnData);
        initEcharts5( projectIds , returnData);
        initEcharts6( projectIds , returnData);
        return returnData;
    }

    /**
     * @description  初始化Echarts1
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts1(String projectIds , R returnData) {
        String condition1 = "".equals( projectIds ) ? "" : " AND b.FprojectID in ("+projectIds+") ";
        String condition2 = " AND b.FSTATE = ? ";

        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        StringBuffer SQL = new StringBuffer( CostEffectiveSQL.SQL_ECHARTS_02 );
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( " group by md.fname  order by md.fname " );
        List<Object[]> echarts1 = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(),audit);
        echarts1.add( new Object [] {"所占比例" , "来访占比", "费用占比", "成交占比" } );
        //成交总金额
        final BigDecimal[] zcjje = {BigDecimal.ZERO};
        list.stream().forEach(itme ->{ zcjje[0] = zcjje[0].add( UIRuleUtil.getBigDecimal( itme.get( "cjAmt" ) ) ); });

        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            String ctname = UIRuleUtil.getString( temp.get("ctname") );
            BigDecimal lrzb = UIRuleUtil.getBigDecimal( temp.get("lrzb") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjfyzb = UIRuleUtil.getBigDecimal( temp.get("cjfyzb") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjAmt = UIRuleUtil.getBigDecimal( temp.get("cjAmt") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjzb = BigDecimal.ZERO.compareTo( zcjje[0] ) == 0 ? BigDecimal.ZERO : cjAmt.divide( zcjje[0], 4, BigDecimal.ROUND_HALF_UP );
            echarts1.add( new Object [] {ctname ,lrzb,cjfyzb,cjzb.multiply( new BigDecimal( "100" ) ) } );
        }
        returnData.put( "echarts1",echarts1 );
    }

    /**
     * @description  初始化Echarts2
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts2(String projectIds , R returnData) {
        StringBuffer SQL = new StringBuffer( "".equals( projectIds ) ? CostEffectiveSQL.SQL_ECHARTS_06 : CostEffectiveSQL.SQL_ECHARTS_05.replaceAll( ":projectIds",projectIds ) );
        List<Object[]> echarts2 = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString());
        //成交总金额
        final BigDecimal[] zcjje = {BigDecimal.ZERO};
        list.stream().forEach(itme ->{ zcjje[0] = zcjje[0].add( UIRuleUtil.getBigDecimal( itme.get( "cjAmt" ) ) ); });

        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            String name = UIRuleUtil.getString( temp.get("fname") );
            BigDecimal cjfyzb = UIRuleUtil.getBigDecimal( temp.get("cjfyzb") ).setScale(1, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjAmt = UIRuleUtil.getBigDecimal( temp.get("cjAmt") ).setScale(1, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjzb = BigDecimal.ZERO.compareTo( zcjje[0] ) == 0 ? BigDecimal.ZERO : cjAmt.divide( zcjje[0], 1, BigDecimal.ROUND_HALF_UP );
            echarts2.add( new Object [] { cjzb.multiply( new BigDecimal( "100" )) ,cjfyzb,name } );
        }

        returnData.put( "echarts2",echarts2 );
    }

    /**
     * @description  初始化Echarts3
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts3(String projectIds , R returnData) {
        if(true){
            return;
        }
        String condition1 = "".equals( projectIds ) ? "" : " AND b.FprojectID in ("+projectIds+") ";
        String condition2 = " AND b.FSTATE = ? ";

        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        StringBuffer SQL = new StringBuffer( CostEffectiveSQL.SQL_ECHARTS_03 );
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( " group by b.FprojectID ,b.fname  " );
        List<Object[]> echarts3 = new ArrayList<>();
        List<Object[]> echarts4 = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(),audit);
        echarts3.add( new Object [] {"" , "" } );
        echarts4.add( new Object [] {"" , "" } );

        BigDecimal average3 = BigDecimal.ZERO;
        BigDecimal average4 = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            String name = UIRuleUtil.getString( temp.get("fname") );
            BigDecimal cjfx = UIRuleUtil.getBigDecimal( temp.get("cjfx") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal amount = UIRuleUtil.getBigDecimal( temp.get("amount") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjAmt = UIRuleUtil.getBigDecimal( temp.get("cjAmt") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal rate = BigDecimal.ZERO.compareTo( amount ) ==0 ? BigDecimal.ZERO : cjAmt.divide(amount,2, BigDecimal.ROUND_HALF_UP )  ;

            echarts3.add( new Object [] {name ,rate } );
            echarts4.add( new Object [] {name ,cjfx.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP ) } );
            average3 = average3.add( rate );
            average4 = average4.add( cjfx );
        }
        average3 = list.size() ==0 ? BigDecimal.ZERO : average3.divide( UIRuleUtil.getBigDecimal( list.size() ),2, BigDecimal.ROUND_HALF_UP )  ;
        average4 = list.size() ==0 ? BigDecimal.ZERO : average4.divide( UIRuleUtil.getBigDecimal( list.size() ),2, BigDecimal.ROUND_HALF_UP )  ;
        echarts3.set(0, new Object [] {"平均费率" , "平均费率"+average3+"%"});
        echarts4.set(0, new Object [] {"平均费效" , "平均费效"+average4.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )+"万元"});
        returnData.put( "echarts3",echarts3 );
        returnData.put( "echarts4",echarts4 );
    }

    /**
     * @description  初始化Echarts4
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts4(String projectIds , R returnData) {
        String condition1 = "".equals( projectIds ) ? "" : " AND l1.FprojectID in ("+projectIds+") ";
        String condition2 = " AND l1.FSTATE = ? ";
        String nowYear = DateUtil.getSysYear();
        String yearMonth = DateUtil.toString( new Date(), DateUtil.YEAR_MONTH );
        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        String yes = ParamEnum.ISYN.YES.getCode();
        String marketingSubjects = ParamEnum.MarketAccount.Market1.getName();

        StringBuffer SQL = new StringBuffer( CostEffectiveSQL.SQL_ECHARTS_07 );
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( " GROUP BY l1.FprojectID  " );
        List<Object[]> echarts3 = new ArrayList<>();
        List<Object[]> echarts4 = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(), new String[]{ audit} );
        BigDecimal average3 = BigDecimal.ZERO;
        BigDecimal average4 = BigDecimal.ZERO;
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            String name = UIRuleUtil.getString(temp.get("name"));
            //成交套数
            BigDecimal cjcount = UIRuleUtil.getBigDecimal( temp.get( "cjcount" ) );
            //成交金额
            BigDecimal cjAmt = UIRuleUtil.getBigDecimal( temp.get( "cjAmt" ) );
            //营销费用
            BigDecimal ysAmt = UIRuleUtil.getBigDecimal( temp.get( "ysAmt" ) );
            //费率   营销费用/销售金额  5月8号变更为  营销费用/成交金额
            //SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_02 );
            //SQL.append( condition1 );
            //SQL.append( " AND l1.FyearMonth like '"+nowYear+"%' " );
            //BigDecimal salesAmount = UIRuleUtil.getBigDecimal( jdbcTemplate.queryForObject( SQL.toString(), String.class ) );
            BigDecimal rate = hundred.multiply( BigDecimal.ZERO.compareTo( cjAmt ) == 0 ? BigDecimal.ZERO : ysAmt.divide( cjAmt, 4, BigDecimal.ROUND_HALF_UP ) ) ;
            //成交费效
            BigDecimal costTransaction = BigDecimal.ZERO.compareTo( cjcount ) == 0 ? BigDecimal.ZERO : ysAmt.divide( cjcount, 2, BigDecimal.ROUND_HALF_UP );
            echarts3.add( new Object [] {name ,rate } );
            echarts4.add( new Object [] {name ,costTransaction } );
            average3 = average3.add( rate );
            average4 = average4.add( costTransaction );
        }
        average3 = list.size() ==0 ? BigDecimal.ZERO : average3.divide( UIRuleUtil.getBigDecimal( list.size() ),2, BigDecimal.ROUND_HALF_UP )  ;
        average4 = list.size() ==0 ? BigDecimal.ZERO : average4.divide( UIRuleUtil.getBigDecimal( list.size() ),2, BigDecimal.ROUND_HALF_UP )  ;
        echarts3 = bubbleSort(echarts3);
        echarts4 = bubbleSort(echarts4);
        echarts3.add(new Object [] {"平均费率" , "平均费率"+average3+"%"});
        echarts4.add(new Object [] {"平均费效" , "平均费效"+average4.divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )+"万元"});
        Collections.reverse(echarts3);
        Collections.reverse(echarts4);
        returnData.put( "echarts3",echarts3 );
        returnData.put( "echarts4",echarts4 );
    }

    /**
     * @description  冒泡排序
     * @param  array  .
     * @return  .
     * @date  20/05/08 17:09
     * @author  wanghb
     * @edit  .
     */
    public static List<Object[]> bubbleSort(List<Object[]> array) {
        if (array.size() == 0){
            return array;
        }
        for (int i = 0; i < array.size(); i++){
            for (int j = 0; j < array.size() - 1 - i; j++){
                if (UIRuleUtil.getInt( array.get(j + 1)[1] ) > UIRuleUtil.getInt( array.get(j)[1] )) {
                    Object[] temp = array.get(j + 1);
                    array.set( (j + 1), array.get(j));
                    array.set( j, temp);
                }
            }

        }

        return array;
    }

    /**
     * @description  初始化Echarts5  费率趋势  和  费效趋势
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts5(String projectIds , R returnData) {
        if(true){
            return;
        }
        String condition1 = "".equals( projectIds ) ? "" : " AND b.FprojectID in ("+projectIds+") ";
        String condition2 = " AND b.FSTATE = ? ";
        String condition3 = " AND DATE_FORMAT(b.FconDate,'%Y') = ? ";

        String nowYear = DateUtil.getSysYear();
        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        StringBuffer SQL = new StringBuffer( CostEffectiveSQL.SQL_ECHARTS_04 );
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( condition3 );
        SQL.append( " group by date_format(b.FconDate,'%Y-%m') ORDER BY date_format(b.FconDate,'%Y-%m') " );
        Map<String, Object> echarts5 = new HashMap<>();
        List<Object> echarts5xAxis = new ArrayList<>();
        List<Object> echarts5data = new ArrayList<>();
        Map<String, Object> echarts6 = new HashMap<>();
        List<Object> echarts6xAxis = new ArrayList<>();
        List<Object> echarts6data = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(),audit,nowYear);

        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            String conDate = UIRuleUtil.getString( temp.get("conDate") );
            if(conDate.length() != 7){
                continue;
            }
            conDate = conDate.substring( 5,7 )+"月";
            //费效
            BigDecimal cjfx = UIRuleUtil.getBigDecimal( temp.get("cjfx") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal amount = UIRuleUtil.getBigDecimal( temp.get("amount") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            BigDecimal cjAmt = UIRuleUtil.getBigDecimal( temp.get("cjAmt") ).setScale(2, BigDecimal.ROUND_HALF_UP);
            //费率 成交金额/费用
            BigDecimal rate = BigDecimal.ZERO.compareTo( amount ) ==0 ? BigDecimal.ZERO : cjAmt.divide(amount,2, BigDecimal.ROUND_HALF_UP )  ;

            echarts5xAxis.add( conDate );
            echarts5data.add( rate );
            echarts6xAxis.add( conDate );
            echarts6data.add( cjfx );
            //average5 = average5.add( rate );
            //average6 = average6.add( cjfx );
        }
        echarts5.put( "xAxis",echarts5xAxis );
        echarts5.put( "data", echarts5data );
        echarts6.put( "xAxis",echarts6xAxis );
        echarts6.put( "data", echarts6data );
        //average5 = list.size() ==0 ? BigDecimal.ZERO : average5.divide( UIRuleUtil.getBigDecimal( list.size() ),2, BigDecimal.ROUND_HALF_UP )  ;
        //average6 = list.size() ==0 ? BigDecimal.ZERO : average6.divide( UIRuleUtil.getBigDecimal( list.size() ),2, BigDecimal.ROUND_HALF_UP )  ;
        //echarts5.set(0, new Object [] {"平均费率" , "平均费率"+average5+"%"});
        //echarts6.set(0, new Object [] {"平均费效" , "平均费效"+average6+"万元"});
        returnData.put( "echarts5",echarts5 );
        returnData.put( "echarts6",echarts6 );
    }

    /**
     * @description  初始化Echarts6
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts6(String projectIds , R returnData) {
        String[] months = {"01","02","03","04","05","06","07","08","09","10","11","12"};
        String condition1 = "".equals( projectIds ) ? "" : " AND l1.FprojectID in ("+projectIds+") ";
        String condition2 = " AND l1.FSTATE = ? ";
        String nowYear = DateUtil.getSysYear();


        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        String yes = ParamEnum.ISYN.YES.getCode();
        String marketingSubjects = ParamEnum.MarketAccount.Market1.getName();
        List<Object> xAxis = new ArrayList<>();
        Map<String, Object> echarts5 = new HashMap<>();
        List<Object> echarts5data = new ArrayList<>();
        Map<String, Object> echarts6 = new HashMap<>();
        List<Object> echarts6data = new ArrayList<>();
        for (int i = 0; i < months.length; i++) {
            String month = months[i];
            Integer nowMonth = UIRuleUtil.getInt( month );
            xAxis.add( month + "月");
            String yearMonth = nowYear + "-" +month ;
            //当月的销售目标
            StringBuffer SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_03 );
            SQL.append( condition1 );
            SQL.append( " AND l1.FyearMonth = ? " );
            List<Map<String, Object>> list0 = jdbcTemplate.queryForList( SQL.toString(), new String[]{ yearMonth} );
            //销售目标
            BigDecimal salesTarget = UIRuleUtil.getBigDecimal( list0.get( 0 ).get( "salesTarget" ) );
            SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_01 );
            SQL.append( condition1 );
            SQL.append( condition2 );
            SQL.append( " AND DATE_FORMAT(l1.FreqDate,'%Y-%m') = ?" );
            List<Map<String, Object>> list2 = jdbcTemplate.queryForList( SQL.toString(), new String[]{ audit, yearMonth} );
            Map<String, Object> temp = list2.size() > 0 ? list2.get( 0 ) : new HashMap<>();
            //成交套数
            BigDecimal cjcount = UIRuleUtil.getBigDecimal( temp.get( "cjcount" ) );
            //营销费用
            BigDecimal ysAmt = UIRuleUtil.getBigDecimal( temp.get( "ysAmt" ) );
            SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_05 );
            SQL.append( condition1 );
            SQL.append( condition2 );
            SQL.append( " AND DATE_FORMAT(l1.FbizDate,'%Y-%m') = ? " );
            //付款申请金额
            BigDecimal taxReqAmt = UIRuleUtil.getBigDecimal( jdbcTemplate.queryForObject( SQL.toString(), new String[]{ audit, yearMonth}, String.class ) );
            //费效   验收单金额  /  成交套数
            BigDecimal costEffective = BigDecimal.ZERO.compareTo( cjcount ) == 0 ? BigDecimal.ZERO : ysAmt.divide( cjcount, 2, BigDecimal.ROUND_HALF_UP );
            //费用计划
            SQL = new StringBuffer( CostEffectiveSQL.SQL_LIST_06 );
            SQL.append( condition1 );
            SQL.append( " AND l1.Fyear = ? " );
            SQL.append( " AND l1.Fmonth = ? " );
            BigDecimal yearBudget = UIRuleUtil.getBigDecimal( jdbcTemplate.queryForObject( SQL.toString(), new Object[]{ nowYear, nowMonth}, String.class ) );
            //yearBudget = yearBudget.subtract( ysAmt );

            //费率  5月8号 费用计划/销售目标
            BigDecimal rate = BigDecimal.ZERO.compareTo( salesTarget ) == 0 ? BigDecimal.ZERO : yearBudget.multiply( hundred ).divide( salesTarget, 2, BigDecimal.ROUND_HALF_UP );
            echarts5data.add( rate );
            echarts6data.add( costEffective );
        }

        echarts5.put( "xAxis",xAxis );
        echarts5.put( "data", echarts5data );
        echarts6.put( "xAxis",xAxis );
        echarts6.put( "data", echarts6data );
        returnData.put( "echarts5",echarts5 );
        returnData.put( "echarts6",echarts6 );
    }


}
