package com.dst.slms.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.dst.slms.base.entity.ContractTypeInfo;
import com.dst.slms.base.entity.MarketProjectInfo;
import com.dst.slms.common.service.util.ComboTreeValueModel;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.utils.SpringContextUtils;
import com.dst.slms.system.entity.SysOrgInfo;

/**
* 类说明
* @author dst email:shilcentry@163.com
* @version V1.0
* @date 创建时间：2020年5月2日 下午4:23:57
*/
public class ProjectBaseHelper {
 
	/**
	 * 组织 项目树
	 * @return
	 */
	public static Object getProjectBaseTree() {
		ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
		EntityQuery eq = new EntityQuery(MarketProjectInfo.class);
		eq.eq("isEnable", true);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("org.number", "asc");
		eq.setOrder(map);
		eq.add();
		
		Set<String> orgIdSet = new HashSet<>();
		List<ComboTreeValueModel> treeData = new ArrayList<ComboTreeValueModel>();
		List<MarketProjectInfo> list = iCrudService.getEntityList(eq,new String[] {"name","number","org.id","org.name","org.number"});
		list.forEach(per->{
			SysOrgInfo orgInfo = per.getOrg();
			if(orgInfo == null ) {
				return;
			}
			ComboTreeValueModel model = new ComboTreeValueModel(orgInfo.getId(),orgInfo.getName(),"");
			ComboTreeValueModel projectModel = new ComboTreeValueModel(per.getId(),per.getName(),orgInfo.getId(),"../assets/css/IconsExtension/calendar_link.png");
			if(!orgIdSet.contains(orgInfo.getId())) {
				treeData.add(model);
			}
			orgIdSet.add(orgInfo.getId());
			treeData.add(projectModel);
		});
		treeData.add(new ComboTreeValueModel("","组织项目",""));
		return treeData;
	}
	/**
	 * 合同类型树
	 * @return
	 */
	public static Object getConTypeTree() {
		ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
		EntityQuery eq = new EntityQuery(ContractTypeInfo.class);
		eq.eq("isEnable", true);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("number", "asc");
		eq.setOrder(map);
		eq.add();
		
		List<ComboTreeValueModel> treeData = new ArrayList<ComboTreeValueModel>();
		List<ContractTypeInfo> list = iCrudService.getEntityList(eq,new String[] {"name","number"});
		list.forEach(per->{
			ContractTypeInfo typeinfo = per;
			if(typeinfo == null ) {
				return;
			}
			ComboTreeValueModel projectModel = new ComboTreeValueModel(per.getId(),per.getName(),typeinfo.getId(),"../assets/css/IconsExtension/calendar_link.png");
			treeData.add(projectModel);
		});
		return treeData;
	}
	/**
	 * 组织树
	 * @return
	 */
	public static Object getOrgTree() {
		ICrudService iCrudService = SpringContextUtils.getBean(ICrudService.class);
		EntityQuery eq = new EntityQuery(SysOrgInfo.class);
		eq.eq("isEnable", true);
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("longNumber", "asc");
		eq.setOrder(map);
		eq.add();
		
		List<ComboTreeValueModel> treeData = new ArrayList<ComboTreeValueModel>();
		List<SysOrgInfo> list = iCrudService.getEntityList(eq,new String[] {"name","number","longNumber"});
		list.forEach(per->{
			SysOrgInfo orgInfo = per;
			if(orgInfo == null ) {
				return;
			}
			ComboTreeValueModel model = new ComboTreeValueModel(orgInfo.getId(),orgInfo.getName(),"");
			treeData.add(model);
		});
		treeData.add(new ComboTreeValueModel("","组织项目",""));
		return treeData;
	}
}
