package com.dst.slms.supplierreview.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.supplierreview.entity.SupplierReviewInfo;
import com.dst.slms.supplierreview.service.ISupplierReviewService;

/**   
 * 供应商评审 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 供应商评审
 * @author 
 * @date 2020-05-02 18:55:41
 * @version V1.0   
 *
 */
public abstract class AbstractSupplierReviewController extends CoreBaseController {

	@Autowired
	private ISupplierReviewService iSupplierReviewService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/supplierreview/supplierreview/supplierReviewList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/supplierreview/supplierreview/supplierReviewEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSupplierReviewService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SupplierReviewInfo info = new SupplierReviewInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("supplierProfile.id");
		sic.add("supplierProfile.number");
		sic.add("supplierProfile.name");
		sic.add("serviceArea");
		sic.add("reviewType.id");
		sic.add("reviewType.number");
		sic.add("reviewType.name");
		sic.add("reviewTemplate.id");
		sic.add("reviewTemplate.number");
		sic.add("reviewTemplate.name");
		sic.add("reviewDate");
		sic.add("effectiveBegin");
		sic.add("effectiveEnd");
		sic.add("finalScore");
		sic.add("referrer");
		sic.add("saleContract.id");
		sic.add("saleContract.number");
		sic.add("saleContract.name");
		sic.add("supplierReviewScore.parent.id");
		sic.add("supplierReviewScore.parent.number");
		sic.add("supplierReviewScore.parent.name");
		sic.add("supplierReviewScore.guideName");
		sic.add("supplierReviewScore.fullNum");
		sic.add("supplierReviewScore.weight");
		sic.add("supplierReviewScore.remark");
		sic.add("supplierReviewScore.iskouF");
		sic.add("supplierReviewScore.score");
		return sic;
	}

	@RequiresPermissions("suw:supplierReview:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SupplierReviewInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("suw:supplierReview:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("suw:supplierReview:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("suw:supplierReview:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SupplierReviewInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("suw:supplierReview:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SupplierReviewInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("suw:supplierReview:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SupplierReviewInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("suw:supplierReview:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SupplierReviewInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("suw:supplierReview:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SupplierReviewInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("suw:supplierReview:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(SupplierReviewInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
