package com.dst.slms.supplierreview.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo;

import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.supplierreview.entity.SupplierReviewInfo;
import com.dst.slms.supplierreview.entity.SupplierReviewScoreInfo;
import com.dst.slms.supplierreview.entity.TemplateChildInfo;
import com.dst.slms.supplierreview.service.ISupplierReviewService;

/**   
 * @Title: 供应商评审 ServiceImpl
 * @Description: 供应商评审
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ISupplierReviewServiceImpl extends BillBaseCrudServiceImpl<SupplierReviewInfo> implements ISupplierReviewService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISupplierReviewServiceImpl.class);

	@Autowired
	private ISupplierReviewService iSupplierReviewService;
	
	@Override
	public List<TemplateChildInfo> getReviewTemplate(String id) {
		EntityQuery eq = new EntityQuery(TemplateChildInfo.class);
		eq.eq("parent.id", id);
		eq.add();
		return iSupplierReviewService.getEntityList(eq);
	}
	
	@Override
	protected R verifyInput(SupplierReviewInfo entity) {
		List<SupplierReviewScoreInfo>  info= entity.getSupplierReviewScore();
		if(info!=null&&info.size()>0){
			BigDecimal countAmount=new   BigDecimal("0");
			for (SupplierReviewScoreInfo supplierReviewScoreInfo : info) {
				if(UIRuleUtil.isNotNull(supplierReviewScoreInfo.getScore())){
					BigDecimal   b1   =   new   BigDecimal(supplierReviewScoreInfo.getScore()+"").setScale(2,4);   			
					countAmount = countAmount.add(b1);  
				}
			}
			if(countAmount.compareTo(new BigDecimal("100")) == 1){
				throw new BizException("评分值大于100！");
			}
		}
		return super.verifyInput(entity);
	}
	
	@Override
	public R audit(String billId, String userId) {
		R r=super.audit(billId, userId);
		if(Integer.valueOf(r.get("code")+"")==200){//审批通过,算出最终得分
			updateFinalScore(billId);
		}
		return r;
	}

	private void updateFinalScore(String billId) {
		SupplierReviewInfo info = iSupplierReviewService.getEntity(SupplierReviewInfo.class, billId);
		StringBuilder sql = new StringBuilder("select IFNULL(L1.FSCORE,0)*(L1.FWEIGHT/100) SCORE,L2.FORGID   from yc_cost_supplierReviewScore l1 left join yc_cost_templateChild l2 on l1.FguideName=l2.FguideName and l1.Fweight=l2.Fweight");
		sql.append(" where l1.FparentId = '"+billId+"' and l1.FiskouF='N' ");
		List<Map<String,Object>> list = iSupplierReviewService.executeSqlQuery(sql.toString());
		Map<String,Object> map = new HashMap<String, Object>();
		if(list!=null&&list.size()>0){
			for (Map<String, Object> mm : list) {
				if(map.containsKey(mm.get("FORGID")+"")){
					map.put(mm.get("FORGID")+"",new  BigDecimal(map.get(mm.get("FORGID")+"")+"").add(new BigDecimal(mm.get("SCORE")+"").setScale(2,4)));
				}else{
					map.put(mm.get("FORGID")+"", new BigDecimal(mm.get("SCORE")+"").setScale(2,4));
				}
			}
		}
		
		sql = new StringBuilder("select L1.FSCORE SCORE,L2.FORGID   from yc_cost_supplierReviewScore l1 left join yc_cost_templateChild l2 on l1.FguideName=l2.FguideName and l1.Fweight=l2.Fweight");
		sql.append(" where l1.FparentId = '"+billId+"' and l1.FiskouF='Y' ");
		list = iSupplierReviewService.executeSqlQuery(sql.toString());
		if(list!=null&&list.size()>0){
			for (Map<String, Object> mm : list) {
				if(map.containsKey(mm.get("FORGID")+"")){
					map.put(mm.get("FORGID")+"",new  BigDecimal(map.get(mm.get("FORGID")+"")+"").add(new BigDecimal("-"+mm.get("SCORE")+"").setScale(2,4)));
				}else{
					map.put(mm.get("FORGID")+"", new BigDecimal("-"+mm.get("SCORE")+"").setScale(2,4));
				}
			}
		}
		sql = new StringBuilder("select L1.FORGID ,L1.FWEIGHT   from yc_cost_unitWeight l1 left join yc_cost_supplierReview l2 on l1.FparentId=l2.FreviewTemplateID");
		sql.append(" where l2.fid = '"+billId+"' ");
		list = iSupplierReviewService.executeSqlQuery(sql.toString());
		BigDecimal score =new   BigDecimal("0");
		if(list!=null&&list.size()>0){
			for (Map<String, Object> mm : list) {
				if(map.containsKey(mm.get("FORGID")+"")){
					BigDecimal   b1   =   new   BigDecimal(mm.get("FWEIGHT")+"").setScale(2,4);   			
					score = score.add(new  BigDecimal( map.get(mm.get("FORGID")+"")+"").multiply(b1.divide( new   BigDecimal("100")))).setScale(2,4);   
				}
			}
		}
		//修改最终得分
		iSupplierReviewService.executeSql("update yc_cost_supplierReview set FfinalScore='"+score+"' where fid='"+billId+"'");
		//修改修改供应商评价
		EntityQuery eq = new EntityQuery(SupplyEvaluationInfo.class);
		eq.eq("isEnable", true);
		eq.add();
		List<SupplyEvaluationInfo> SupplyEvaluationList= iSupplierReviewService.getEntityList(eq,new String[]{"id","maxScore","minScore"});
		if(SupplyEvaluationList!=null&&SupplyEvaluationList.size()>0){
			for (SupplyEvaluationInfo supplyEvaluationInfo : SupplyEvaluationList) {
				if((score.compareTo(supplyEvaluationInfo.getMaxScore())==-1||score.compareTo(supplyEvaluationInfo.getMaxScore())==0)&&(score.compareTo(supplyEvaluationInfo.getMinScore())==1||score.compareTo(supplyEvaluationInfo.getMinScore())==0)){
					iSupplierReviewService.executeSql("update yc_cost_supplierProfile set FsupplyEvaluationID='"+supplyEvaluationInfo.getId()+"' where fid='"+info.getSupplierProfile().getId()+"'");
				}
			}
		}
	}

}