package com.dst.slms.supplierreview.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 部门权重 Info 对象
 * @Description: 部门权重
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractUnitWeightInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.supplierreview.entity.ReviewTemplateInfo parent;
	
	/**部门*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="部门" )
	private com.dst.slms.system.entity.SysOrgInfo org;
	
	/**权重%*/
	@Column(name ="Fweight")
	@FieldMeta(name="权重%" )
	private java.math.BigDecimal weight;
	
	
	/**
	 *方法: 取得com.dst.slms.supplierreview.entity.ReviewTemplateInfo
	 *@return: com.dst.slms.supplierreview.entity.ReviewTemplateInfo  父对象关联
	 */
	public com.dst.slms.supplierreview.entity.ReviewTemplateInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.supplierreview.entity.ReviewTemplateInfo
	 *@param: com.dst.slms.supplierreview.entity.ReviewTemplateInfo  父对象关联
	 */
	public void setParent(com.dst.slms.supplierreview.entity.ReviewTemplateInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  部门
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrg(){
		return this.org;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  部门
	 */
	public void setOrg(com.dst.slms.system.entity.SysOrgInfo org){
		this.org = org;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  权重%
	 */
	public java.math.BigDecimal getWeight(){
		return this.weight;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  权重%
	 */
	public void setWeight(java.math.BigDecimal weight){
		this.weight = weight;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "L6O55RZG";
	}
}
