package com.dst.slms.supplierprofile.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.supplierprofile.entity.SupplierClassificatioInfo;
import com.dst.slms.supplierprofile.service.ISupplierClassificatioService;

/**   
 * 供应商分类 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 供应商分类
 * @author 
 * @date 2020-05-02 14:59:27
 * @version V1.0   
 *
 */
public abstract class AbstractSupplierClassificatioController extends CoreBaseController {

	@Autowired
	private ISupplierClassificatioService iSupplierClassificatioService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/supplierprofile/supplierclassificatio/supplierClassificatioList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/supplierprofile/supplierclassificatio/supplierClassificatioEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSupplierClassificatioService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SupplierClassificatioInfo info = new SupplierClassificatioInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		return sic;
	}
	
	@RequiresPermissions("suo:supplierClassificatio:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SupplierClassificatioInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("suo:supplierClassificatio:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("suo:supplierClassificatio:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("suo:supplierClassificatio:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SupplierClassificatioInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("suo:supplierClassificatio:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SupplierClassificatioInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("suo:supplierClassificatio:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SupplierClassificatioInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("suo:supplierClassificatio:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SupplierClassificatioInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("suo:supplierClassificatio:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SupplierClassificatioInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("suo:supplierClassificatio:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(SupplierClassificatioInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
