package com.dst.slms.supplierprofile.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.supplierprofile.entity.SupplyEvaluationInfo;
import com.dst.slms.supplierprofile.service.ISupplyEvaluationService;

/**   
 * @Title: 供应商评价 ServiceImpl
 * @Description: 供应商评价
 * @author 
 * @date 2020-05-02 14:59:27
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ISupplyEvaluationServiceImpl extends CrudServiceImpl<SupplyEvaluationInfo> implements ISupplyEvaluationService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISupplyEvaluationServiceImpl.class);

	@Autowired
	private ISupplyEvaluationService iSupplyEvaluationService;
	
	public R changeEnable(SupplyEvaluationInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iSupplyEvaluationService.executeHql("update SupplyEvaluationInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}