package com.dst.slms.plan.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.plan.entity.AnnualPaymentPlanInfo;
import com.dst.slms.plan.service.IAnnualPaymentPlanService;

/**   
 * 年度支付计划 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 年度支付计划
 * @author 
 * @date 2020-05-03 11:15:04
 * @version V1.0   
 *
 */
public abstract class AbstractAnnualPaymentPlanController extends CoreBaseController {

	@Autowired
	private IAnnualPaymentPlanService iAnnualPaymentPlanService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/plan/annualpaymentplan/annualPaymentPlanList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/plan/annualpaymentplan/annualPaymentPlanEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iAnnualPaymentPlanService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		AnnualPaymentPlanInfo info = new AnnualPaymentPlanInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("year");
		sic.add("marketProject.id");
		sic.add("marketProject.number");
		sic.add("marketProject.name");
		sic.add("org.id");
		sic.add("org.number");
		sic.add("org.name");
		sic.add("isnew");
		sic.add("editionnumber");
		sic.add("annualPlanDetails.parent.id");
		sic.add("annualPlanDetails.parent.number");
		sic.add("annualPlanDetails.parent.name");
		sic.add("annualPlanDetails.marketAccoun.id");
		sic.add("annualPlanDetails.marketAccoun.number");
		sic.add("annualPlanDetails.marketAccoun.name");
		sic.add("annualPlanDetails.marketAccounName");
		sic.add("annualPlanDetails.amountTotal");
		sic.add("annualPlanDetails.jan");
		sic.add("annualPlanDetails.feb");
		sic.add("annualPlanDetails.mar");
		sic.add("annualPlanDetails.apr");
		sic.add("annualPlanDetails.may");
		sic.add("annualPlanDetails.jun");
		sic.add("annualPlanDetails.jul");
		sic.add("annualPlanDetails.aug");
		sic.add("annualPlanDetails.sep");
		sic.add("annualPlanDetails.oct");
		sic.add("annualPlanDetails.nov");
		sic.add("annualPlanDetails.dec");
		return sic;
	}

	@RequiresPermissions("ann:annualPaymentPlan:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(AnnualPaymentPlanInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("ann:annualPaymentPlan:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("ann:annualPaymentPlan:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("ann:annualPaymentPlan:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(AnnualPaymentPlanInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("ann:annualPaymentPlan:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(AnnualPaymentPlanInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("ann:annualPaymentPlan:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(AnnualPaymentPlanInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("ann:annualPaymentPlan:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(AnnualPaymentPlanInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("ann:annualPaymentPlan:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(AnnualPaymentPlanInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("ann:annualPaymentPlan:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(AnnualPaymentPlanInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
