package com.dst.slms.base.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.base.entity.MediaInfoInfo;
import com.dst.slms.base.service.IMediaInfoService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 媒体信息 Controller
 * @Description: 媒体信息
 * @author 
 * @date 2020-05-02 10:08:28
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/mediaInfoController")
@SysPermissionName(name="媒体信息",type=Constant.MENU)
public class MediaInfoController extends AbstractMediaInfoController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(MediaInfoController.class);

	@Autowired
	private IMediaInfoService iMediaInfoService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(MediaInfoInfo info, HttpServletRequest req) {
		return iMediaInfoService.changeEnable(info,req);
	}
	
	@Override
	protected boolean isIgnoreCUFilter() {
		return true;
	}
}
