package com.cftech.showroom.relevanter.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.showroom.relevanter.model.Relevanter;
import com.cftech.showroom.relevanter.service.RelevanterService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 展厅申请相关人Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String RELEVANTER_VIEW = "qy:relevanter:view"
 * 查看:public static final String RELEVANTER_EDIT = "qy:relevanter:edit"
 *
 * @author lisw
 * @date: 2019-08-01 13:36
 */
@Slf4j
@Controller
@RequestMapping("/a/relevanter")
public class RelevanterController {

    public static final String RELEVANTER_VIEW = "qy:relevanter:view";
    public static final String RELEVANTER_EDIT = "qy:relevanter:edit";

    @Autowired
    private RelevanterService relevanterService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = RELEVANTER_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "relevanter/relevanterlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = RELEVANTER_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Relevanter relevanter = relevanterService.fetchById(id);
            model.addAttribute("data", relevanter);
        }
        return "relevanter/relevanterform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = RELEVANTER_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Relevanter relevanter, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (relevanter != null && relevanter.getId() != null) {
                relevanter.setUpdateBy(UserUtils.getUser().getId());
                relevanterService.update(relevanter);
                rtnJson.put("errorNo", 0);
            } else {
                relevanter.setNumber(codingruleUtils.getNumber(accountsId, Relevanter.class.getName()));
                relevanter.setAccountsId(accountsId);
                relevanter.setDelFlag(false);
                relevanter.setAccountsId(UserUtils.getmpaccounts(request));
                relevanter.setCreateBy(UserUtils.getUser().getId());
                relevanter.setUpdateBy(UserUtils.getUser().getId());
                relevanterService.save(relevanter);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = RELEVANTER_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Relevanter relevanter, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(relevanter.getNumber())) {
            conds.like("number", relevanter.getNumber());
        }
        if (!StringUtils.isEmpty(relevanter.getName())) {
            conds.like("name", relevanter.getName());
        }
        if (!StringUtils.isEmpty(relevanter.getEmail())) {
            conds.like("email", relevanter.getEmail());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Relevanter> list = relevanterService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = relevanterService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = RELEVANTER_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            relevanterService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequestMapping("/exportExcel")
    @RequiresPermissions(value = RELEVANTER_VIEW)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, Relevanter relevanter) {
        Long accountId = UserUtils.getmpaccounts(request);
        Sort sort = new Sort("create_time", OrderType.ASC);
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        if (!StringUtils.isEmpty(relevanter.getNumber())) {
            conds.like("number", relevanter.getNumber());
        }
        if (!StringUtils.isEmpty(relevanter.getName())) {
            conds.like("name", relevanter.getName());
        }
        if (!StringUtils.isEmpty(relevanter.getEmail())) {
            conds.like("email", relevanter.getEmail());
        }
        List<Relevanter> list = relevanterService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(Relevanter.class, response).toExcel(list, "展厅申请需求单接收人信息");
    }

    @RequestMapping("/templateExcel")
    @RequiresPermissions(value = RELEVANTER_VIEW)
    public void templateExcel(HttpServletRequest request, HttpServletResponse response) {
        ExcelKit.$Export(Relevanter.class, response).toExcel(null, "展厅申请需求单接收人信息");
    }

    @RequestMapping("/importExcel")
    @RequiresPermissions(value = RELEVANTER_EDIT)
    @ResponseBody
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        JSONObject retJson = new JSONObject();
        Long userId = UserUtils.getUser().getId();
        if (file == null) {
            retJson.put("errorNo", "1");
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
// 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            ExcelKit.$Import().readExcel(storeFile, rowData -> {
                if (!StringUtils.isEmpty(rowData.get(0))) {
                    Relevanter relevanter = new Relevanter();
                    relevanter.setAccountsId(accountId);
                    relevanter.setName(rowData.get(0));
                    relevanter.setCreateBy(userId);
                    relevanter.setUpdateBy(userId);
                    relevanter.setEmail(rowData.get(1));
                    relevanter.setStatus(rowData.get(2));
                    relevanter.setSort(rowData.get(3));
                    relevanterService.save(relevanter);
                }
            });
        } catch (IOException e) {
            log.error(e.getMessage());
        }
        retJson.put("errorNo", "0");
        retJson.put("errorMsg", "导入成功");
        return retJson;
    }

}

