package com.cftech.brand.apply.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @version V1.0
 * @Package com.cftech.brand.apply.model
 * @Name cftech-platform
 * @Description: TODO 品牌申请单成品信息
 * @date 2020/6/17
 */
@Data
public class  BrandApplyProduct implements Serializable {

    /** 主键ID */
    private Long id;

    /**
     * 申请单ID
     */
    private Long applyId;

    /**
     * 成品图片路径
     */
    private String fileUrl;

    /**
     * 内容格式（文件后缀）
     */
    private String format;

    /**
     * 文件名称
     */
    private String name;

    /**
     * 标签
     */
    private String label;

    /**
     * 删除标识
     */
    private boolean delFlag;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 更新人
     */
    private Long updateBy;

    /**
     * 文件存储位置
     */
    private Long cosconfigId;

    /**
     * 文件存储前缀（部门盘链接）
     */
    private String filePrefix;

    public BrandApplyProduct() {
        this.delFlag = false;
    }

}
