package com.cftech.cms.email_record.service.impl;

import com.cftech.cms.email_record.model.Email_record;
import com.cftech.cms.email_record.dao.Email_recordMapper;
import com.cftech.cms.email_record.model.Email_recordDto;
import com.cftech.cms.email_record.service.Email_recordService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2019-03-11 14:11
 */
@Service("email_recordService")
public class Email_recordServiceImpl extends GenericServiceImpl<Email_record> implements Email_recordService {

    @Autowired
    @Qualifier("email_recordMapper")
    private Email_recordMapper email_recordMapper;

    @Override
    public GenericDao<Email_record> getGenericMapper() {
        return email_recordMapper;
    }

    @Override
    public List<Email_recordDto> selectEmailRecord(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return email_recordMapper.selectEmailRecord(params);
    };

    @Override
    public  int selectEmailRecordCount (Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds",conds);
        return email_recordMapper.selectEmailRecordCount(params);
    };

}