package com.cftech.sys.security;

/**
 * 权限标识配置类, <br>
 * 与 permission 权限表 中的 permission_sign 字段 相对应 <br>
 * 使用:
 * 
 * <pre>
 * &#064;RequiresPermissions(value = PermissionConfig.USER_CREATE)
 * public String create() {
 *     return &quot;拥有user:create权限,能访问&quot;;
 * }
 * </pre>
 * 
 * @author lisw
 * @since 2016年8月24日 下午3:58:51
 **/
public class PermissionSign {


    /**
     * 用户编辑权限 标识
     */
    public static final String USER_EDIT = "sys:user:edit";
    
    /**
     * 用户查看权限 标识
     */
    public static final String USER_VIEWS = "sys:user:view";

    
    /**
     * 角色查看权限 标识
     */
    public static final String ROLE_VIEWS = "sys:role:view";
    
    /**
     * 角色编辑权限 标识
     */
    public static final String ROLE_EDIT = "sys:role:edit";
    
    /**
     * 菜单查看权限 标识
     */
    public static final String MENU_VIEWS = "sys:menu:view";
    
    /**
     *菜单编辑权限 标识
     */
    public static final String MENU_EDIT = "sys:menu:edit";
    
    /**
     * 公众账户编辑权限 标识
     */
    public static final String ACCOUNT_EDIT = "mp:account:edit";
    
    /**
     * 公众账户查看权限 标识
     */
    public static final String ACCOUNT_VIEWS = "mp:account:view";
    
    /**
     * 注册会员列表
     */
    public static final String MEMBER_VIEWS = "mp:member:view";
    
    /**
     * 评论内容列表
     */
    public static final String COMMENT_VIEWS = "mp:comment:view";
    
    /**
     * 修改评论内容
     */
    public static final String COMMENT_EDIT = "mp:comment:edit";
    
    /**
     * 卡卷列表
     */
    public  static final String CARD_VIEWS = "mp:card:view";
    
    /**
     * 收藏列表
     */
    public  static final String FAVORITE_VIEWS = "mp:favorite:view";
    
    /**
     * 活动列表
     */
    public  static final String ACTIVITY_VIEWS = "mp:activity:view";
    
    /**
     * 活动详情编辑
     */
    public  static final String ACTIVITY_EDIT = "mp:activity:edit";
    
    /**
     * 活动审批模板列表
     */
    public  static final String ACTIVITY_TEMPLATE_VIEWS = "mp:activity:template:view";
    
    /**
     * 活动审批模板详情编辑
     */
    public  static final String ACTIVITY_TEMPLATE_EDIT = "mp:activity:template:edit";
    
    /**
     * 查看个人中心会员验证码长度及格式
     */
    public static final String PHONE_CODE = "mp:phone:edit";
    
    /**
     * 地区列表
     */
    public static final String AREA_VIEWS = "mp:area:view";
    
    /**
     * 编辑地区
     */
    public static final String 	AREA_EDIT = "mp:area:edit";
    
    /**
     * 新品推荐分类查看
     */
    public static final String NEW_RECDTYPE_VIEWS="mp:newrecdtype:view";
    
    /**
     * 新品推荐分类编辑
     */
    public static final String NEW_RECDTYPE_EDIT= "mp:newrecdtype:edit";
    
    /**
     * 新品推荐查看
     */
    public static final String NEW_PRODUCTS_VIEWS = "mp:newproducts:view";
    
    /**
     * 新品推荐编辑
     */
    public static final String NEW_PRODUCTS_EDIT = "mp:newproducts:edit";

    
    /**
     * 图文消息列表查看
     */
    public static final String IMAGE_TEXT_VIEW = "mp:imagetext:view";
    
    /**
     * 图文消息列表编辑
     */
    public static final String IMAGE_TEXT_EDIT= "mp:imagetext:edit";

    /**
     * 后台日志列表
     */
    public static final String SYSLOG_VIEWS = "mp:syslog:view";
    
    /**
     * 消息回复编辑
     */
    public static final String REPLY_EDIT = "mp:reply:edit";
    
    /**
     * 消息回复查看
     */
    public static final String REPLY_VIEW = "mp:reply:view";
    
    /**
     * 微信菜单查看
     */
    public static final String MPMENU_VIEW = "mp:menu:view";
    
    /**
     *微信菜单编辑
     */
    public static final String MPMENU_EDIT = "mp:menu:edit";

    /**
     * 二维码查看
     */
    public static final String QRCODE_VIEW = "mp:qrcode:view";
    /**
     * 二维码编辑
     */
    public static final String QRCODE_EDIT = "mp:qrcode:edit";

    /**
     * 品牌新闻查看
     */
    public static final String BRANDNEWS_VIEW = "mp:brandnews:view";
    /**
     * 品牌新闻编辑
     */
    public static final String BRANDNEWS_EDIT = "mp:qrcode:edit";
    /**
     * 设计师会员查看
     */
    public static final String DESIGNER_VIEW = "mp:designer:view";
    /**
     * 设计师会员查看
     */
    public static final String DESIGNER_EDIT = "mp:designer:edit";
    /**
     * 设计师会员审核
     * */
    public static final String DESIGNER_AUTH = "mp:designer:auth";
    /**
     * 设计师会员积分
     * */
    public static final String DESIGNER_INTEGRAL = "mp:designer:integral";
    /**
     * 产品查看
     */
    public static final String PRODUCT_VIEW = "mp:product:view";
    /**
     * 产品编辑
     */
    public static final String PRODUCT_EDIT = "mp:product:edit";
    /**
     * 卡券LOGO设置
     */
    public static final String CARDLOGO_EDIT = "mp:cardlogo:edit";
    /**
     * 卡券信息查看
     */
    public static final String CARD_VIEW = "mp:card:view";
    /**
     * 卡券信息编辑
     */
    public static final String CARD_EDIT = "mp:card:edit";
    /**
     * 设计案例查看
     */
    public static final String EXAMPLE_VIEW = "mp:example:view";
    /**
     * 设计案例编辑
     */
    public static final String EXAMPLE_EDIT = "mp:example:edit";
    /**
     * 积分查看
     */
    public static final String INTEGRAL_VIEW = "mp:integral:view";
    /**
     * 积分编辑
     */
    public static final String INTEGRAL_EDIT = "mp:integral:edit";
    
    /**
     * 微信图文素材查看
     */
    public static final String NEWSMEDIA_VIEW = "mp:newsmedia:view";
    
    /**
     * 微信图文素材编辑
     */
    public static final String NEWSMEDIA_EDIT = "mp:newsmedia:edit";
    
    /**
     * 微信图库查看
     */
    public static final String IMAGMEDIA_VIEW = "mp:imagemedia:view";
    
    /**
     * 微信图库编辑
     */
    public static final String IMAGMEDIA_EDIT = "mp:imagemedia:edit";
    
    /**
     * 粉丝图表数据分析
     */
    public static final String FANSSCHARTS_DATA = "mp:fansscharts:data";
    /**
     * 潜客列表
     */
    public static final String PCUSTOMER_VIEW = "mp:pcustomer:view";
    /**
     * 定单列表
     */
    public static final String REPORT_VIEW = "mp:report:view";
    /**
     * 定单列表
     */
    public static final String REPORT_EDIT = "mp:report:edit";
    /**
     * 粉丝标签编辑
     */
    public static final String FANSS_EDIT = "mp:fanss:edit";

    /**
     * 组织查看
     */
    public static final String ORGUNIT_VIEW = "sys:orgunit:view";
    /**
     * 组织编辑
     */
    public static final String ORGUNIT_EDIT = "sys:orgunit:edit";
    /**
     * 组织分类查看
     */
    public static final String ORGTYPE_VIEW = "sys:orgtype:view";
    /**
     * 组织分类编辑
     */
    public static final String ORGTYPE_EDIT = "sys:orgtype:edit";
    
    /**
     * 商品查看
     */
    public static final String COMMODITY_VIEW = "qy:commodity:view";
    /**
     * 商品编辑
     */
    public static final String COMMODITY_EDIT = "qy:commodity:edit";
    /**
     * 商品分类查看
     */
    public static final String COMMODITYPE_VIEW = "qy:commoditype:view";
    /**
     * 商品分类编辑
     */
    public static final String COMMODITYPE_EDIT = "qy:commoditype:edit";
    /**
     * 商品品牌查看
     */
    public static final String COMMODITYBRAND_VIEW = "qy:commoditybrand:view";
    /**
     * 商品品牌编辑
     */
    public static final String COMMODITYBRAND_EDIT = "qy:commoditybrand:edit";
    
    /**
     * 终端档案查看
     */
    public static final String TERMINAL_VIEW = "qy:terminal:view";
    /**
     * 终端档案编辑
     */
    public static final String TERMINAL_EDIT = "qy:terminal:edit";
    
    /**
     * 终端档案类型查看
     */
    public static final String TERMINALTYPE_VIEW = "qy:terminaltype:view";
    /**
     * 终端档案类型查看
     */
    public static final String TERMINALTYPE_EDIT = "qy:terminaltype:edit";

    /**
     * 职位查看
     */
    public static final String POSITION_VIEW = "sys:position:view";
    /**
     * 职位编辑
     */
    public static final String POSITION_EDIT = "sys:position:edit";
    /**
     * 企业标签查看
     */
    public static final String QYTAG_VIEW = "sys:qytag:view";
    /**
     * 企业标签编辑
     */
    public static final String QYTAG_EDIT = "sys:qytag:edit";
    /**
     * 企业号人员查看
     */
    public static final String QYUSER_VIEW = "sys:qyuser:view";
    /**
     * 企业号人员编辑
     */
    public static final String QYUSER_EDIT = "sys:qyuser:edit";
     
    /**
     * 工作计划查看
     */
    public static final String SCHEDULE_VIEW = "qy:schedule:view";
    /**
     * 工作计划编辑
     */
    public static final String SCHEDULE_EDIT = "qy:schedule:edit" ;

    /**
     * 企业号人员查看
     */
    public static final String CODINGRULE_VIEW = "sys:codingrule:view";
    /**
     * 企业号人员编辑
     */
    public static final String CODINGRULE_EDIT = "sys:codingrule:edit";

    /**
     * 企业号人员查看
     */
    public static final String VISITROUTE_VIEW = "qy:visitroute:view";
    /**
     * 企业号人员编辑
     */
    public static final String VISITROUTE_EDIT = "qy:visitroute:edit";

    /**
     * 应用菜单查看
     */
    public static final String APPMENU_VIEW = "qy:appmenu:view";
    /**
     * 应用菜单编辑
     */
    public static final String APPMENU_EDIT = "qy:appmenu:edit";
    
    /**
     * 信息采集列表查看
     */
    public static final String INFOCOLLECTION_VIEW = "qy:infocollection:view";
    
}
