package com.cftech.questionnaire.core.paper.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.paper.model.PaperBaseEntity;
import com.cftech.questionnaire.core.paper.model.PaperSubject;
import com.cftech.questionnaire.core.paper.model.SelectActivity;

import java.util.List;
import java.util.Map;

/**
* 问卷Service
*
* @author wxf
* @date: 2017-05-25 13:48
*/
public interface PaperService extends GenericService<PaperBaseEntity> {

    /**
     * 分页查询
     *
     * @param pId   哪个分类下的人员列表
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<PaperBaseEntity> fetchSearchVOByPage(Long pId, Conds conds, Sort sort, int page, int pageSize);

    int count(Long pId, Conds conds);

    /**
     * 保存对象
     *
     * @param t
     * @return
     */
    boolean saveBatch(PaperBaseEntity t);


    /**
     * 保存对象
     *
     * @param t
     * @return
     */
    boolean updateBatch(PaperBaseEntity t);

    /**
     * 选择活动
     * @param conds
     * @param sort
     * @param page
     * @param pageSize
     * @return
     */
    List<SelectActivity> searchActivity(Conds conds, Sort sort, int page, int pageSize);

    /**
     * 活动个数
     * @param conds
     * @return
     */
    int countActivity(Conds conds);

    List<PaperSubject> selectPaperSubject(Conds conds);

}
