package com.cftech.addresst.dao;

import com.alibaba.fastjson.JSONObject;
import com.cftech.addresst.model.Address;
import com.cftech.addresst.model.AddressVO;
import com.cftech.addresst.model.Area;
import com.cftech.core.generic.GenericDao;

import java.util.List;
import java.util.Map;

/**
* 收货地址管理Mapper
*
* @author Licc
* @date: 2020-09-29 17:17
*/
public interface AddressMapper extends GenericDao<Address> {
    /**
     *
     * @Description  省市区地址查询
     * @Date 14:58 2020/10/20
     * @Param
     * @return
     **/
    List<Area> listArea();
    /**
     * @Description  个人收货地址数据回填
     * @Date 9:53 2020/10/20
     * @Param
     * @return
     **/
    List<AddressVO> addressList(String openId);
    /**
     * @Description  根据id查询收货地址
     * @Date 9:53 2020/10/20
     * @Param
     * @return
     **/

    List<AddressVO> addressId(Long id);
    /**
     *
     * @Description  默认地址修改
     * @Date 11:44 2020/10/20
     * @Param
     * @return
     *
     **/
    int updateWhether(Map<String,Object> param);
    /**
     *
     * @Description  查询是否有默认地址
     * @Date 11:44 2020/10/20
     * @Param
     * @return
     *
     **/

    Integer whetherList(String openId);
}