package com.cftech.cms.exhibi_inquiries.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.exhibi_inquiries.model.Exhibi_inquiries;
import com.cftech.cms.exhibi_inquiries.service.Exhibi_inquiriesService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.MpTokenUtil;
import com.cftech.cos.config.cosconfig.model.Cosconfig;
import org.mp.api.wxbase.wxmedia.JwMediaAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * Created by Ago on 2018/9/11.
 */
@RestController
@RequestMapping(value = "/mobile/auth/inquiries")
public class MobileExhibi_inquiriesController {

    @Autowired
    private Exhibi_inquiriesService exhibi_inquiriesService;
    @Autowired
    private MpTokenUtil tokenUtil;

    /**
     * 提交问题反馈
     * @param exhibi_inquiries
     * @return
     */
    @RequestMapping(value = "/submitinquiries",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject submitinquiries(Exhibi_inquiries exhibi_inquiries,Long accountsId){
        JSONObject jsonObject = new JSONObject();
       try {
           if(exhibi_inquiries!= null){
               if(com.cftech.core.util.StringUtils.isNotBlank(exhibi_inquiries.getInquiries_picture())){
                   Cosconfig cosconfig = new Cosconfig();
                   cosconfig.setCosType("qcloud");
                   /**
                    * 按照需要上传逻辑，做上传的相关配置
                    */
                   net.sf.json.JSONObject mediaJson= JwMediaAPI.downMedia(tokenUtil.getToken(accountsId),exhibi_inquiries.getInquiries_picture(),"",cosconfig);
                   String image = mediaJson.getString("fileName");
                   exhibi_inquiries.setInquiries_picture(image);
               }
               boolean flag = exhibi_inquiriesService.save(exhibi_inquiries);
               if(flag){
                   jsonObject.put("errorNo",0);
               }
           }else{
               jsonObject.put("errorNo",2);
           }
       }catch (Exception e){
           e.printStackTrace();
           jsonObject.put("errorNo",1);
       }
        return  jsonObject;
    }

    /**
     * 返回问题询问
     * @param exhibi_id 展会id
     * @param openId 微信OPENID
     * @return
     */
    @RequestMapping(value = "/returninquiries",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject returninquiries(HttpServletRequest request, Long exhibi_id, String openId){
        JSONObject jsonObject = new JSONObject();
        try {
            if(!StringUtils.isEmpty(exhibi_id)&&!StringUtils.isEmpty(openId)){
                Conds conds = new Conds();
                conds.equal("e.del_flag",0);
                conds.equal("e.exhibi_id",exhibi_id);
                conds.equal("e.open_id",openId);
                Sort sort = new Sort("e.create_time", OrderType.DESC);
                List<Exhibi_inquiries> list = exhibi_inquiriesService.fetchSearchByPage(conds,sort,0,0);
                if(list!=null&&list.size()>0){
                    jsonObject.put("errorNo",0);
                    jsonObject.put("data",list.get(0));
                }
            }else{
                jsonObject.put("errorNo",2);
            }
        }catch (Exception e){
            e.printStackTrace();
            jsonObject.put("errorNo",1);
        }
        return  jsonObject;
    }
}
