package com.cftech.cms.exhibi.service.impl;

import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.cms.exhibi.model.Browse;
import com.cftech.cms.exhibi.model.Exhibi;
import com.cftech.cms.exhibi.dao.ExhibiMapper;
import com.cftech.cms.exhibi.service.BrowseService;
import com.cftech.cms.exhibi.service.ExhibiService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.shop.qrcode.dao.WxQrcodeMapper;
import com.cftech.shop.qrcode.model.WxQrcode;
import com.cftech.sys.security.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-12 16:14
 */
@Service("exhibiService")
public class ExhibiServiceImpl extends GenericServiceImpl<Exhibi> implements ExhibiService {

    @Autowired
    @Qualifier("exhibiMapper")
    private ExhibiMapper exhibiMapper;

    @Autowired
    private BrowseService browseService;

    @Autowired
    private CodingruleUtils codingruleUtils;

    @Autowired
    private WxQrcodeMapper qrcodeMapper;

    @Override
    public GenericDao<Exhibi> getGenericMapper() {
        return exhibiMapper;
    }

    //下载二维码
    @Override
    public void addcode(WxQrcode qrcode , Exhibi exhibi){
        try {


            exhibi.setQr_code(qrcode.getTicket());

            exhibiMapper.update(exhibi);
            qrcodeMapper.save(qrcode);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 更新浏览表里面的数据和展会表里面的阅读量
     * @param openid 微信的openID
     * @param exhibi_id 展会ID
     * @param  accounts_id  服务号的ID
     * @param exhibi 展会类
     */
    public void updatebrowse(String openid, String exhibi_id , Long accounts_id, HttpServletRequest request, Exhibi exhibi){

        try {
            Browse browse = new Browse();
            browse.setOpenid(openid);
            browse.setExhibi_id(Long.valueOf(exhibi_id));
            browse.setNumber(codingruleUtils.getNumber(accounts_id, Browse.class.getName()));
            browse.setAccountsId(accounts_id);
            browse.setDelFlag(false);
            /*browse.setCreateBy(openid);
            browse.setUpdateBy(openid);*/
            browseService.save(browse);
            //浏览一次   就加1
            if(exhibi.getReading()!=null){
                exhibi.setReading(exhibi.getReading()+1);
            }else{
                exhibi.setReading(Long.valueOf(1));
            }
            exhibi.setDelFlag(false);
            exhibi.setAccountsId(accounts_id);
            exhibiMapper.update(exhibi);
        }catch (Exception e){
            e.printStackTrace();
        }


    };



}