var invitationCode = (function () {
  'use strict';
  var InvitationCode = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/member/judgeivitecode',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/exhibition.json';
    }


    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {
      if (initBaseFields()) {
        log();
        submit()

        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "个人中心",
        modulename: "邀请码",
        keyword: "邀请码",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/aidea/mobile/testAsync/doLOg', formdata, function (retdata) {

      });
    }




    var submit = function () {

      $('#submit').click(function () {
        var code = $('#code').val();
        if (!code || code == '') {
          $.modal({
            title: "",
            text: '<span class="color-green">请输入邀请码！</span><br>Please input the<br>invitation code',
            buttons: [{
              text: "确定OK"
            }]
          });
          return false;
        }
        var formdata = {
          invitcode: code
        };
        G.ajax('get', p.params.dataApi, formdata, function (retdata) {
          //0:验证成功 1:系统错误 2:验证无效 3:邀请码已被使用
          if (retdata.errorNo == '0') {

            $.modal({
              title: "",
              text: '<span class="color-green">验证成功！</span><br>Authentication is successful',
              buttons: [{
                text: "确定OK",onClick:function(){
                    if(p.empInfo.memberId!=null &&  p.empInfo.memberId!=''){
                      location.href='meeting-intro.html?appid='+p.params.appid+'&invitcode='+code+"&id="+retdata.meetingId;
                    }else{
                      location.href='register.html?appid='+p.params.appid+'&invitcode='+code+"&id="+retdata.meetingId+
                          '&company='+retdata.organization+'&surname='+retdata.surname+'&name='+retdata.name+'&sex='+retdata.sex;;
                    }

                }
              }]
            });
          } else if (retdata.errorNo == '1') {
            $.modal({
              title: "",
              text: '<span class="color-green">系统错误！</span><br>System error',
              buttons: [{
                text: "确定OK"
              }]
            });

          } else if (retdata.errorNo == '2') {
            $.modal({
              title: "",
              text: '<span class="color-green">邀请码无效！</span><br>The invitation code is invalid!',
              buttons: [{
                text: "确定OK"
              }]
            });

          } else if (retdata.errorNo == '3') {
            $.modal({
              title: "",
              text: '<span class="color-green">邀请码已被使用！</span><br>The invitation code<br>has been used.',
              buttons: [{
                text: "确定OK"
              }]
            });

          }

        });
      })

    }


  };

  return InvitationCode;
})();