package com.cftech.membercard.register.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.membercard.register.model.InputType;
import com.cftech.membercard.register.model.Register;
import com.cftech.membercard.register.service.RegisterService;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 会员卡注册配置Controller
 *
 * 权限字符串说明:
 * 查看:public static final String REGISTER_VIEW = "qy:register:view"
 * 查看:public static final String REGISTER_EDIT = "qy:register:edit"
 *
 * @author wxf
 * @date: 2017-06-22 13:45
 */
@Slf4j
@Controller
@RequestMapping("/a/register")
public class RegisterController {

    public static final String REGISTER_VIEW = "qy:register:view";
    public static final String REGISTER_EDIT = "qy:register:edit";

    @Autowired
    private RegisterService registerService;


    //列表页面
    @RequiresPermissions(value = REGISTER_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "register/registerlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = REGISTER_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Register register = registerService.fetchById(id);
            if(register==null){
                register=new Register();
                Long accountid=UserUtils.getmpaccounts(request);
                register.setAccountsId(accountid);
                register.setCreateBy(accountid);
                register.setUpdateBy(accountid);
                register.setDelFlag(false);
                registerService.save(register);
            }
            model.addAttribute("data", register);
        }
        model.addAttribute("inputType", JSONArray.fromObject(InputType.values()).toString());
        return "register/registerform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = REGISTER_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Register register, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (register != null && register.getId() != null) {
                register.setUpdateBy(UserUtils.getUser().getId());
                registerService.update(register);
                rtnJson.put("errorNo", 0);
            } else {
                register.setAccountsId(accountsId);
                register.setDelFlag(false);
                register.setAccountsId(UserUtils.getmpaccounts(request));
                register.setCreateBy(UserUtils.getUser().getId());
                register.setUpdateBy(UserUtils.getUser().getId());
                registerService.save(register);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = REGISTER_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Register register, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Register> list = registerService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = registerService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = REGISTER_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            registerService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
