package com.cftech.activity.log.service.impl;

import com.cftech.activity.log.dao.EggsLogMapper;
import com.cftech.activity.log.model.EggsLog;
import com.cftech.activity.log.model.EggsLogDto;
import com.cftech.activity.log.service.EggsLogService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 砸金蛋活动记录表ServiceImpl
 *
 * @author wuxf
 * @date: 2017-04-28
 */
@Service("eggsLogService")
public class EggsLogServiceImpl extends GenericServiceImpl<EggsLog> implements EggsLogService {

    @Autowired
    @Qualifier("eggsLogMapper")
    private EggsLogMapper eggsLogMapper;

    @Override
    public GenericDao<EggsLog> getGenericMapper() {
        return eggsLogMapper;
    }

    @Override
    public List<EggsLogDto> fetchSearchByPageDto(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return eggsLogMapper.fetchSearchByPageDto(params);
    }

}

