var appraise = (function () {
    'use strict';
    return function (params) {
        var p = this;
        p.params = {
            appid: '',
            accountsId: '',
            cfApp: null,
            devMode: false,
            submitApi: G.baseUri() + '/mobile/brandApply/submitEvaluate',
            vt: ''
        };
        for (var param in params) {
            p.params[param] = params[param];
        }
        var cfApp = p.params.cfApp;
        // p.english = cfApp.getQueryString('english') == 1 ? true : false;
        if (p.params.devMode) {
            p.params.dataApi = 'json/code.json';
            p.params.returnqustion = 'json/code.json';
        }


        var serverId;

        /**
         * 判断app字段
         * @returns 是否app有值
         */
        var validAppField = function () {
            if (!p.params.appid || p.params.appid == '') {
                return false;
            } else {
                return true;
            }
        };

        /**
         * 确认初始化的app 和tokenId 两个值是否都存在
         * 如果不存在则获取一次,获取不到则初始化失败
         * @returns 初始化基础字段是否成功
         */
        var initBaseFields = function () {
            if (!validAppField()) {
                p.params.appid = cfApp.getQueryString('appid');
                //p.params.accountsId = cfApp.getQueryString('accountsId');
            }


            //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
            if (!validAppField()) {
                if (p.params.cfApp) {
                    p.params.appid = cfApp.getAppId();
                    //p.params.tokenId = cfApp.getTokenId();
                }
            }
            p.empInfo = cfApp.getMpInfo();
            p.params.accountsId = p.empInfo.accountsId;
            p.id=cfApp.getQueryString("id");
            return validAppField();
        };

        /**
         * 初始化组件
         * @returns {boolean}
         */
        p.init = function () {
            if (initBaseFields()) {
                submit();
                log();
                return true;
            } else {
                return false;
            }
        };

        var log = function () {
            var formdata = {
                openid: p.empInfo.openId,
                module: "品牌服务申请",
                modulename: '评分',
                keyword: '评分',
                keywordid: '',
                vt: new Date().getTime(),
                appid: cfApp.getQueryString('appid'),
                url: location.href
            };
            G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


            });
        }


        //确认
        var submit = function () {
            $('#submit').click(function () {
                var  serviceScore=$('#star').val();
                if (StringValidateUtils.isEmpty(serviceScore)) {
                    $.modal({
                        title: "",
                        text: '<span class="color-green">请留下您的评分</span><br>Please leave your star',
                        buttons: [{
                            text: "确定OK"
                        }]
                    });
                    return false;
                }
                var feedback=$('#suggestions').val()
                // if (StringValidateUtils.isEmpty(feedback)) {
                //     $.modal({
                //         title: "",
                //         text: '<span class="color-green">请留下您宝贵的建议或反馈</span><br>Please leave your valuable suggestions or feedback',
                //         buttons: [{
                //             text: "确定OK"
                //         }]
                //     });
                //     return false;
                // }
                var formJson={
                    id:p.id,
                    openId:p.empInfo.openId,
                    serviceScore:serviceScore,
                    feedback:feedback
                }
                G.ajax("post", p.params.submitApi, formJson, function (retdata) {
                    if (retdata.errorNo == '0') {
                        toast('评价提交成功.Evaluation submitted successfully.');
                    } else {
                        $.modal({
                            title: "",
                            text: '<span class="color-green">提交异常！</span></br>System error',
                            buttons: [{
                                text: "确定OK"
                            }]
                        });
                    }
                })
            })
        }

        var show = function(html, className) {
            className = className || "";
            var mask = $("<div class='weui-mask_transparent'></div>").appendTo(document.body);

            var tpl = '<div class="weui-toast ' + className + '">' + html + '</div>';
            var dialog = $(tpl).appendTo(document.body);

            dialog.addClass("weui-toast--visible");
            dialog.show();
        };

        var hide = function(callback) {
            $(".weui-mask_transparent").remove();
            var done = false;
            var $el = $(".weui-toast--visible").removeClass("weui-toast--visible").transitionEnd(function() {
                var $this = $(this);
                $this.remove();
                callback && callback();
                done = true
            });
            setTimeout(function () {
                if (!done) {
                    $el.remove()
                    callback && callback();
                }
            }, 1000)
        };

        var toast = function(text, callback) {
            show('<i class="icon"></i><p class="weui-toast_content">' + (text || "OK") + '</p>');
            setTimeout(function() {
                hide(callback);
            }, 2000);
        }

    };

})();

/**
 * 评星点击事件
 */
function starClick(that) {
    var num = $(that).data().star
    $('#star').val(num)
    var tips = $('#star-tips')
    if (num == 1) {
        tips.html('不好 Poor')
    } else if (num == 2) {
        tips.html('不是很好 Not so good ')
    } else if(num==3){
        tips.html('一般 Average ');
    }else if ( num ==4) {
        tips.html('很好Good')
    } else if (num === 5) {
        tips.html('非常好Very good')
    }
    var star = $(that).parent().find('.star')
   if (star && star.length) {
       for (var i = 0; i < num; i++) {
           $(star[i]).addClass('stared')
       }
   }
   if (star && star.length) {
       for (var j = 4; j >= num; j--) {
           $(star[j]).removeClass('stared')
       }
   }
}