package com.cftech.workshop.activ.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.workshop.activ.model.Activ;
import com.cftech.workshop.activ.dao.ActivMapper;
import com.cftech.workshop.activ.model.SelectActivity;
import com.cftech.workshop.activ.service.ActivService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-29 15:13
 */
@Service("activService")
public class ActivServiceImpl extends GenericServiceImpl<Activ> implements ActivService {

    @Autowired
    @Qualifier("activMapper")
    private ActivMapper activMapper;

    @Override
    public GenericDao<Activ> getGenericMapper() {
        return activMapper;
    }

    /**
     * 选择活动
     * @param conds
     * @param sort
     * @param page
     * @param pageSize
     * @return
     */
    @Override
    public List<SelectActivity> searchActivity(Conds conds, Sort sort, int page, int pageSize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return activMapper.searchActivity(params);
    };

    /**
     * 活动个数
     * @param conds
     * @return
     */
    @Override
    public int countActivity(Conds conds){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return activMapper.countActivity(params);
    };

}