package com.cftech.sys.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.util.OutputJSONUtil;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.model.Role;
import com.cftech.sys.model.User;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import com.cftech.sys.service.RoleService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Controller
@RequestMapping("/a/role")
public class RoleController 
{
    @Resource
    private RoleService roleService;

    
    //角色列表
    @RequiresPermissions(value= PermissionSign.ROLE_VIEWS)
    @RequestMapping(value = "",method = {RequestMethod.GET, RequestMethod.POST})
    public String roleList(Role role,Model model) {
    	model.addAttribute("role", role);
        return "managerole/rolelist";
    }
    
    //管理后台用户列表
    @RequiresPermissions(value=PermissionSign.ROLE_EDIT)
    @RequestMapping(value = "/roleform",method = {RequestMethod.GET,RequestMethod.POST})
    public String useradd(HttpServletRequest request, HttpServletResponse response) {
        return "managerole/roleadd";
    }
    
    
    //更新角色
    @RequiresPermissions(value=PermissionSign.ROLE_EDIT)
    @RequestMapping(value = "/roleaformDetail",method = {RequestMethod.GET,RequestMethod.POST})
    public String roleaupdate(HttpServletRequest request, HttpServletResponse response,Model model) 
    {
    	Role role = roleService.getByPrimaryKey(Long.parseLong(request.getParameter("id")));
    	model.addAttribute("role", role);
        return "managerole/roleupdate";
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setAutoGrowCollectionLimit(Integer.MAX_VALUE);
    }
    
    
    //修改角色 
    @RequiresPermissions(value=PermissionSign.ROLE_EDIT)
    @RequestMapping(value = "/updaterole",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject updaterole(Role role, HttpServletRequest request, HttpServletResponse response)
    {
    	JSONObject returnObj = new JSONObject();
     	returnObj.put("errorCode", 0);
    	roleService.updateRole(role);
        return returnObj;
    }
    
    
    
    //保存角色
    @RequiresPermissions(value=PermissionSign.ROLE_EDIT)
    @RequestMapping(value = "/insertrole",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject insertRole(Role role,HttpServletRequest request, HttpServletResponse response)
    {
    	JSONObject returnObj = new JSONObject();
     	returnObj.put("errorCode", 0);
    	User user = UserUtils.getUser();//获得当前用户
    	role.setUserid(user.getId());
    	roleService.insertRole(role);
        return returnObj;
    }
    
    
    //获取数据
    @RequestMapping(value = "/fetchdata",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject getUsers(int iDisplayStart,int iDisplayLength,HttpServletResponse response,Role role)
    {
        JSONObject returnObj = new JSONObject();
        String roleName = null;
        if(role!=null && StringUtils.isNotBlank(role.getRoleName())){
        	roleName=role.getRoleName();
        }
        List<Role> users=roleService.selectAll(roleName);
        returnObj.put("aaData", users);
        return returnObj;
    }
    
    @RequestMapping(value = "removeRole",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject removeUser(Long id){
    	JSONObject rtnJson = new JSONObject();
    	try {
    		Role role=roleService.getByPrimaryKey(id);
        	if(role!=null){
        		role.setDelflag(1);
        		roleService.updateRole(role);
        		rtnJson.put("errorNo",0);
        	}else{
        		rtnJson.put("errorNo",1);
        	}
		} catch (Exception e) {
			rtnJson.put("errorNo",1);
		}
    	return rtnJson;
    }
    
    
//	//管理后台用户列表 
//    @RequestMapping(value = "")
//    public void userlist(HttpServletRequest request, HttpServletResponse response) 
//    {
//    	Role role = roleService.getByPrimaryKey(Long.parseLong("1"));
//    	System.out.println(role);
//    }
}
