package com.cftech.showroom.visitorCategory.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.core.poi.OnReadDataHandler;
import com.cftech.showroom.visitorCategory.model.VisitorCategory;
import com.cftech.showroom.visitorCategory.service.VisitorCategoryService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * 展厅申请来访者类别Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String VISITORCATEGORY_VIEW = "qy:visitorCategory:view"
 * 查看:public static final String VISITORCATEGORY_EDIT = "qy:visitorCategory:edit"
 *
 * @author lisw
 * @date: 2019-07-31 15:25
 */
@Slf4j
@Controller
@RequestMapping("/a/visitorCategory")
public class VisitorCategoryController {

    public static final String VISITORCATEGORY_VIEW = "qy:visitorCategory:view";
    public static final String VISITORCATEGORY_EDIT = "qy:visitorCategory:edit";

    @Autowired
    private VisitorCategoryService visitorCategoryService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = VISITORCATEGORY_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "visitorCategory/visitorCategorylist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = VISITORCATEGORY_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            VisitorCategory visitorCategory = visitorCategoryService.fetchById(id);
            model.addAttribute("data", visitorCategory);
        }
        return "visitorCategory/visitorCategoryform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = VISITORCATEGORY_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(VisitorCategory visitorCategory, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (visitorCategory != null && visitorCategory.getId() != null) {
                visitorCategory.setUpdateBy(UserUtils.getUser().getId());
                visitorCategoryService.update(visitorCategory);
                rtnJson.put("errorNo", 0);
            } else {
                visitorCategory.setNumber(codingruleUtils.getNumber(accountsId, VisitorCategory.class.getName()));
                visitorCategory.setAccountsId(accountsId);
                visitorCategory.setDelFlag(false);
                visitorCategory.setAccountsId(UserUtils.getmpaccounts(request));
                visitorCategory.setCreateBy(UserUtils.getUser().getId());
                visitorCategory.setUpdateBy(UserUtils.getUser().getId());
                visitorCategoryService.save(visitorCategory);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }



    //获取列表数据
    @RequiresPermissions(value = VISITORCATEGORY_VIEW)
    @RequestMapping(value = "/listData")
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, VisitorCategory visitorCategory, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(visitorCategory.getNumber())) {
            conds.like("number", visitorCategory.getNumber());
        }
        if (!StringUtils.isEmpty(visitorCategory.getName())) {
            conds.like("name", visitorCategory.getName());
        }
        if (!StringUtils.isEmpty(visitorCategory.getIsExplainer())) {
            conds.like("is_explainer", visitorCategory.getIsExplainer());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<VisitorCategory> list = visitorCategoryService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = visitorCategoryService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = VISITORCATEGORY_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            visitorCategoryService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }


    //下载模板
    @RequestMapping(value = "/templateExcel" , method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = VISITORCATEGORY_VIEW)
    @ResponseBody
    public void templateExcel(HttpServletRequest request, HttpServletResponse response , VisitorCategory visitorCategory) {
        // 生成Excel并使用浏览器下载

        ExcelKit.$Export(VisitorCategory.class, response).toExcel(null, "来访者类别");
    }


    @RequestMapping(value = "/exportExcel" , method = {RequestMethod.GET,RequestMethod.POST})
    @RequiresPermissions(value = VISITORCATEGORY_VIEW)
    @ResponseBody
    public void exportInviteCodeExcel(HttpServletRequest request, HttpServletResponse response , VisitorCategory visitorCategory ) {
        // 生成Excel并使用浏览器下载
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(visitorCategory.getNumber())) {
            conds.like("number", visitorCategory.getNumber());
        }
        if (!StringUtils.isEmpty(visitorCategory.getName())) {
            conds.like("name", visitorCategory.getName());
        }
        if (!StringUtils.isEmpty(visitorCategory.getIsExplainer())) {
            conds.like("is_explainer", visitorCategory.getIsExplainer());
        }
        Sort sort = new Sort("sort", OrderType.ASC);

        List<VisitorCategory> list = visitorCategoryService.fetchSearchByPage(conds, sort, 0, 0);
        ExcelKit.$Export(VisitorCategory.class, response).toExcel(list, "来访者类别");
    }


    //导入
    @RequestMapping(value = "/importExcel" , method = {RequestMethod.POST,RequestMethod.GET})
    @ResponseBody
    @RequiresPermissions(value = VISITORCATEGORY_EDIT)
    public JSONObject importExcel(HttpServletRequest request, MultipartFile file, Model model, Long id) {
        JSONObject retJson = new JSONObject();
        Long accountId = UserUtils.getmpaccounts(request);
        Long userId= UserUtils.getUser().getId();
        StringBuffer stringBuffer = new StringBuffer();
        if (file == null) {
            retJson.put("errorNo", "1");
            retJson.put("errorMsg", "未选择导入文件");
            return retJson;
        }
        // 构造临时路径来存储上传的文件
        String uploadPath = System.getProperty("java.io.tmpdir");
        File uploadDir = new File(uploadPath);
        if (!uploadDir.exists()) {
            uploadDir.mkdir();
        }
        String fileName = file.getOriginalFilename();
        String filePath = uploadPath + File.separator + fileName;
        File storeFile = new File(filePath);
        try {
            file.transferTo(storeFile);
            int i =0;
            ExcelKit.$Import().setEmptyCellValue(null).readExcel(storeFile, new OnReadDataHandler() {
                @Override
                public void handler(List<String> rowData) {
                    VisitorCategory visitorCategory = new VisitorCategory();
                    if(!StringUtils.isEmpty(rowData.get(0))){
                        visitorCategory.setName(rowData.get(0));
                    }
                    if(StringUtils.isEmpty(rowData.get(1))){
                        visitorCategory.setIsExplainer("1");
                    }else{
                        visitorCategory.setIsExplainer(rowData.get(1));
                    }
                    if(!StringUtils.isEmpty(rowData.get(2))){
                        visitorCategory.setSort(rowData.get(2));
                    }
                    visitorCategory.setAccountsId(accountId);
                    visitorCategory.setCreateBy(userId);
                    visitorCategory.setUpdateBy(userId);
                    visitorCategoryService.save(visitorCategory);
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        retJson.put("errorNo", "0");
        retJson.put("errorMsg", "导入成功");
        return retJson;
    }

}
