package com.cftech.brand.material.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类别
 *
 * @author faye
 * @date 2020/01/14
 */
@Data
public class BrandMaterial implements Serializable {

    /** 主键id */
    private Long id;
    /** 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /** 名称 */
    @ExportConfig(value = "名称", width = 100)
    private String name;
    /** 所属部门id */
    private Long departementId;

//    @ExportConfig(value = "所属部门", width = 100)
    private String departmentNumber;


    /** 所属分类id */
    private Long categoryId;

    @ExportConfig(value = "所属分类", width = 100)
    private String categoryNumber;

    /**
     * 所属分类名称
     */
    private String categoryName;

    /** 所属的账号 */
    private Long accountsId;
    /** 删除标识 */
    private boolean delFlag;
    /** 状态 */
    private String status;
    /** 创建时间 */
    private Date createTime;
    /** 更新时间 */
    private Date updateTime;
    /** 备注 */
    private String description;
    /** 创建人 */
    private Long createBy;
    /** 更新人 */
    private Long updateBy;

    public BrandMaterial() {
        this.delFlag = false;
        this.status = "0";
    }

}