package com.cftech.brand.apply.service.impl;

import com.cftech.brand.apply.dao.BrandApplyMapper;
import com.cftech.brand.apply.dao.BrandApplyProductMapper;
import com.cftech.brand.apply.model.BrandApplyProduct;
import com.cftech.brand.apply.service.BrandApplyProductService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @version V1.0
 * @Package com.cftech.brand.apply.service.impl
 * @Name cftech-platform
 * @Description: TODO 品牌成品
 * @date 2020/6/22
 */
@Service("brandApplyProductService")
public class BrandApplyProductServiceImpl extends GenericServiceImpl<BrandApplyProduct> implements BrandApplyProductService {

    @Autowired
    @Qualifier("brandApplyProductMapper")
    private BrandApplyProductMapper brandApplyProductMapper;

    @Override
    protected GenericDao<BrandApplyProduct> getGenericMapper() {
        return brandApplyProductMapper;
    }

    @Override
    public List<BrandApplyProduct> fetchByApplyId(Long applyId) {
        return brandApplyProductMapper.fetchByApplyId(applyId);
    }
}
