package com.cftech.base.org.service;

import com.cftech.base.org.model.OrgUnit;
import com.cftech.base.org.model.vo.OrgUnitVO;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;
import java.util.Map;

/**
 * brandnewsService
 * Created by mb 07/11/2016.
 */
public interface OrgUnitService extends GenericService<OrgUnit> {

	List<OrgUnit> findAllChildren(Long orgId);

	List<OrgUnit> findAllByAccountId(Long accountId);

	boolean saveCache(OrgUnit orgUnit);

	boolean updateCache(OrgUnit orgUnit);

    boolean move(Map<String, Object> map);

    /**
     * 分页查询
     *
     * @param orgId    按当前组织往下查
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return List<OrgUnitVO>
     */
    List<OrgUnitVO> fetchSearchVOByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize);

    /**
     * 分页查询
     *
     * @param orgId    按当前组织往下查
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return List<OrgUnitVO>
     */
    List<OrgUnit> fetchSearchByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize);

    int count(Long orgId, Conds conds);

    /**
     * 按条件改变记录的状态
     *
     * @param status 改变成的状态
     * @param conds  条件
     */
    void changeStatus(String status, Conds conds);

    /**
     * 根据微信账号和职位的编码查找组织
     *
     * @param accountId 微信账号
     * @param number    组织编码
     * @return Position
     */
    OrgUnit findByAccountIdAndNumber(Long accountId, String number);
    
	
}
