package com.cftech.collection.model;

import lombok.Data;

import java.io.Serializable;
import java.sql.Date;

/**
 * wx_collection 实体类
 * 点赞表
 * Created by mubo 11/05/2017.
 */
@Data
public class Collection implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 服务号或企业号标识
     */
    private Long accountsId;

    /**
     * 被收藏模块枚举
     */
    private String moduleType;

    /**
     * 收藏实体主键
     */
    private Long entityId;

    /**
     * 操作类型枚举
     * 1 收藏 2 分享 
     */
    private String type;


    /**
     * 收藏人
     */
    private String userId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 记录时效性
     */
    private Boolean delFlag;

    /**
     * 门店ID
     */
    private Long storeId;



    public Collection() {
        this.delFlag = false;
    }
}