package com.cftech.core.poi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Excel导出项配置
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD })
public @interface ExportConfig {

	
	/**
	 * 表头显示名
	 * @return 默认为字段名
	 */
	String value() default "field";
	
	/**
	 * 单元格宽度
	 * @return 默认300
	 */
	short width() default 300;
	
	/**
	 * 是否导出数据(如果不导出数据,Ĭ将以“******”填充单元格)
	 * @return 默认true
	 */
	boolean isExportData() default true;


	/**
	 * 是否显示， 0 都显示，1导出时显示，2导入时显示
	 * @return
	 */
	int showLevel() default 0;

	/**
	 * 日期格式化， 空就不格式化，否则按定义的格式化，譬如 yyyy-MM-dd
	 * 只用于导出
	 * @return
	 */
	String dateFormat() default "";


}
