package com.cftech.product.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.product.service.ProductService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import sun.util.resources.cldr.gv.LocaleNames_gv;

/**
 * @author ：licc
 * @date ：Created in 2020/10/21 14:10
 * @description：药品分类
 */
@Slf4j
@RestController
@RequestMapping("mobile/auth/product")
public class MobileProductController {
    @Autowired
    private ProductService productService;
    /**
     * @Author Licc
     * @Description  根据id查询商品详情
     * @Date 11:05 2020/10/22
     * @Param  
     * @return 
     **/
    @RequestMapping(value = "/productId",method = {RequestMethod.GET,RequestMethod.POST},produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject productMenu(Long ID){
        return productService.productId(ID);
    }
}
