package com.cftech.order.dao;

import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.order.model.*;
import com.cftech.core.generic.GenericDao;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
* 订单管理Mapper
*
* @author Licc
* @date: 2020-10-10 14:20
*/
public interface OrderMapper extends GenericDao<Order> {
    List<Order> fetchSearchBy(Conds conds, Sort sort, int page, int pageSize , Long id);
    List<ProductOrder> listProduct();
    OrderFromVO fetchId(Serializable id);
    List<OrderFromVO> fetchProductId(Serializable id);
    ProductDto fetchProduct(Map<String, Object> params);
    Integer saveDetill(OrderDetail orderDetail);
    Integer fetcheDeta(Map<String, Object> params);
    Long updateDetill(Map<String, Object> params);
    Order fetchOrder(Long id);
    Long updateOrder(Map<String, Object> params);


}