package com.cftech.orderdetail.service;

import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.orderdetail.model.OrderDetails;
import com.cftech.core.generic.GenericService;

import java.util.List;

/**
* 订单管理Service
*
* @author Licc
* @date: 2020-10-16 11:26
*/
public interface OrderDetailsService extends GenericService<OrderDetails> {


    /**
     * 通过客服、药师、订单员获取列表
     * @param userId
     * @param conds
     * @param sort
     * @param iDisplayStart
     * @param iDisplayLength
     */
    List<OrderDetails> fetchSearchByPageByUser(String userId, Conds conds, Sort sort, int iDisplayStart, int iDisplayLength);
}
