package com.cftech.sys.service.impl;

import com.cftech.sys.dao.RoleMapper;
import com.cftech.sys.model.Role;
import com.cftech.sys.model.RoleExample;
import com.cftech.sys.model.UserRole;
import com.cftech.sys.service.RoleService;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lisw
 * @date 2016年9月20日 下午1:57:21
 *
 */
@Service
public class RoleServiceImpl implements RoleService {

    @Resource
    private RoleMapper roleMapper;
    
    

  

    @Override
    public List<UserRole> selectRolesByUserId(Long userId) {
        return roleMapper.selectRolesByUserId(userId);
    }

	@Override
	public Role getByPrimaryKey(Long id) {
		  return roleMapper.getByPrimaryKey(id);
	}

	@Override
	public List<Role> selectAll(String roleName) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("roleName", roleName);
		return roleMapper.selectAll(params);
	}


	@Override
	public void insertRole(Role r) {
		// TODO Auto-generated method stub
		roleMapper.insertRole(r);
		//删除所有的ROLE 
		roleMapper.deleteRolePermission(r.getId());
		roleMapper.insertRolePermission(r);
	}


	@Override
	public void updateRole(Role r) 
	{
		roleMapper.updateRole(r);
		//删除所有的ROLE 
		roleMapper.deleteRolePermission(r.getId());
		if(r.getPermission().size()>0)
		{
			roleMapper.insertRolePermission(r);
		}
	}

	@Override
	public List<Role> getRoleByIds(String roleids) {
    	List<Long> ids = Lists.newArrayList();

    	String[] roles = roleids.split(",");
    	for (String role:roles) {
    		ids.add(Long.valueOf(role));
		}
		RoleExample example = new RoleExample();

		RoleExample.Criteria criteria = example.createCriteria();
		criteria.andIdIn(ids);
		criteria.andDelFlagEqualTo("0");
    	return roleMapper.selectByExample(example);
	}

	
	@Override
	public List<UserRole> selectRolesByAccountsId(Long accountId) {
		return roleMapper.selectRolesByAccountsId(accountId);
	}

	@Override
	public List<UserRole> selectRolesByUserAccountsId(Long userId,
			Long accountsId) {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("userId",userId);
		params.put("accountsId",accountsId);
		return roleMapper.selectRolesByUserAccountsId(params);
	}
	
	public List<Role> selectAllSign(String roleSign){
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("roleSign", roleSign);
		return roleMapper.selectAllSign(params);
	}
}
