package com.cftech.base.org.service;

import com.cftech.base.org.model.Position;
import com.cftech.base.org.model.vo.PositionVO;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;

import java.util.List;
import java.util.Map;

/**
 * positionService
 * Created by Neil 14/02/2017.
 */
public interface PositionService extends GenericService<Position> {

    /**
     * 分页查询
     *
     * @param positionId  只能查看下级的职位
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return List<PositionVO>
     */
    List<PositionVO> fetchSearchVOByPage(Long positionId, Conds conds, Sort sort, int page, int pageSize);

    List<Position> fetchSearchByPage(Long positionId, Conds conds, Sort sort, int page, int pageSize);

    int count(Long positionId, Conds conds);

    /**
     * 根据微信账号和职位的编码查找职位
     *
     * @param accountId 微信账号
     * @param number    职位编码
     * @return Position
     */
    Position findByAccountIdAndNumber(Long accountId, String number);
    
    /**
     * 查询此人下面所有存在人员的职位ID
     * 
     * 或者查询某职位下面所有的人员
     */
    List<Map<String,Object> > getSubordinatePostion(Map<String, Object> params);

}
