package com.cftech.mp.wechat.service;

import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.mp.wechat.model.Qrcode;
import com.cftech.mp.wechat.model.QrcodeDto;

import java.util.List;

/**
 * qrcodeService
 * Created by mb 01/11/2016.
 */
public interface QrcodeService extends GenericService<Qrcode> {
	
	 /**
     * 分页查询
     *
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<QrcodeDto> fetchSearchByPageStore(Conds conds, Sort sort, int page, int pageSize);
    
    /**
     * 查询总条数
     *
     * @param conds 条件
     * @return 条数
     */
    int countStore(Conds conds);

}
