package com.cftech.like.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.like.dao.LikeMapper;
import com.cftech.like.model.Like;
import com.cftech.like.model.LikeDto;
import com.cftech.review.dao.ReviewMapper;
import com.cftech.review.model.Review;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;


import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * likeService
 * Created by mubo 10/05/2017.
 */
@Service("likeService")
public class LikeServiceImpl extends GenericServiceImpl<Like> implements com.cftech.like.service.LikeService {

	/**
	 * likeMapper
	 */
	@Autowired
	@Qualifier("likeMapper")
	private LikeMapper likeMapper;


	@Autowired
	private ReviewMapper reviewMapper;

	@Override
	public GenericDao<Like> getGenericMapper() {
		return likeMapper;
	}

	@Override
	public Boolean saveLike(Like like) {
		//生成点赞记录（一个用户对一个记录只有一条）
		Long saveResult = getGenericMapper().save(like);
		//生成点赞log（记录所有操作记录）
		int logResult = likeMapper.saveLog(like);
		return saveResult*logResult > 0;
	}

	@Override
	public Boolean clearLike(Like like) {
		HashMap params = new HashMap();
		Conds conds = new Conds();
		conds.equal("module_type",like.getModuleType());
		conds.equal("entity_id",like.getEntityId());
		conds.equal("type",0);
		conds.equal("user_id",like.getUserId());
		params.put("conds",conds);
		//删除点赞记录
		int deleteResult = likeMapper.deleteForever(params);
		//生成点赞log
		int logResult = likeMapper.saveLog(like);

		return deleteResult*logResult>0;
	}

	@Override
	public List<LikeDto> findLikeByPage(Conds conds, Sort sort, int page, int pageSize) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("conds", conds);
		params.put("offset", page > 0 ? page : 0);
		params.put("limit", pageSize > 0 ? pageSize : 0);
		params.put("sort", sort);
		return likeMapper.findLikeByPage(params);
	}

	@Override
	public Integer findLikeCount(Conds conds) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("conds", conds);
		return likeMapper.findLikeCount(params);
	}

	@Override
	public Integer getLikeCount(Conds conds) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("conds", conds);
		return likeMapper.getLikeCount(params);
	}

	//在相应点赞模块实体下的表里面修改点赞量
	@Override
	public void saveModulLike(Like like){
		Map<String,Object> parmas = new HashMap<String,Object>();
		//生成点赞记录（一个用户对一个记录只有一条）
		if(like.getType().equals("0")) { //0:点赞
			Long saveResult = getGenericMapper().save(like);
		}else{
			HashMap params = new HashMap();
			Conds conds = new Conds();
			conds.equal("module_type",like.getModuleType());
			conds.equal("entity_id",like.getEntityId());
			conds.equal("type",0);
			conds.equal("user_id",like.getUserId());
			params.put("conds",conds);
			//删除点赞记录
			int deleteResult = likeMapper.deleteForever(params);
		}

		//生成点赞log（记录所有操作记录）
		like.setId(null);
		int logResult = likeMapper.saveLog(like);
		if(like.getModuleType().equals("0")){ // 0:展会模块
			parmas.put("id",like.getEntityId());
			if(like.getType().equals("0")){ //0:点赞
				parmas.put("count",1);
				likeMapper.updateExhibiLikeCount(parmas);
			}else{ //  1:取消点赞
				parmas.put("count",-1);
				likeMapper.updateExhibiLikeCount(parmas);
			}
		}else{ // 1:评论模块
			Review review = reviewMapper.fetchById(like.getEntityId());
			if(like.getType().equals("0")){ //0:点赞
					review.setFabulous(review.getFabulous()+1);
					reviewMapper.update(review);
			}else{
					review.setFabulous(review.getFabulous()-1);
					reviewMapper.update(review);
			}
		}
	}
}
