package com.cftech.workshop.template.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.dao.SysJobMapper;
import com.cftech.accounts.model.SysJob;
import com.cftech.accounts.service.JobTask;
import com.cftech.core.util.SpringContextHolder;
import com.cftech.workshop.template.model.Template;
import com.cftech.workshop.template.dao.TemplateMapper;
import com.cftech.workshop.template.service.TemplateService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.UUID;

/**
 * 研讨会模板消息ServiceImpl
 *
 * @author lisw
 * @date: 2018-07-18 16:45
 */
@Service("templateService")
public class TemplateServiceImpl extends GenericServiceImpl<Template> implements TemplateService {

    @Autowired
    @Qualifier("templateMapper")
    private TemplateMapper templateMapper;

    @Autowired
    private SysJobMapper jobMapper;

    @Autowired
    private JobTask jobTask;

    @Autowired
    private JedisPool jedisPool;


    @Override
    public GenericDao<Template> getGenericMapper() {
        return templateMapper;
    }

    @Override
    public void saveTemplate(Template template) {
        String uuid = UUID.randomUUID().toString();
        template.setUuid(uuid);
//        templateMapper.save(template);
//        JedisPool jedisPoolInfo =  (JedisPool)SpringContextHolder.getApplicationContext().getBean("jedisPool");
        Jedis jedis = jedisPool.getResource();
        JSONObject data = JSONObject.parseObject(JSONObject.toJSONString(template));
        JSONObject result = new JSONObject();
        result.put("status","1");
        result.put("data",data);
        jedis.publish("job_listener",result.toJSONString());
        jedis.close();
//        SysJob job = new SysJob();
//        job.setStatus("1");
//        job.setDelFlag(false);
//        job.setCreateBy(template.getCreateBy());
//        job.setUpdateBy(template.getUpdateBy());
//        job.setJobuid(uuid);
//        job.setAccountsId(template.getAccountsId());
//        job.setJobDesc(template.getSendTimeStr());
//        job.setJobName(template.getJobname());
//        job.setType(template.getType());
//        job.setClazzPath("com.cftech.workshop.template.service.JobDemo2");
//        jobMapper.save(job);
//        jobTask.startJob(job);

    }

    @Override
    public void updateTemplate(Template template) {
        templateMapper.update(template);
        SysJob job = new SysJob();
        job.setStatus("1");
        job.setDelFlag(false);
        job.setCreateBy(template.getCreateBy());
        job.setUpdateBy(template.getUpdateBy());
        job.setJobuid(template.getUuid());
        job.setAccountsId(template.getAccountsId());
        job.setJobDesc(template.getSendTimeStr());
        job.setJobName(template.getJobname());
        job.setType(template.getType());
        job.setClazzPath("com.cftech.workshop.template.service.JobDemo2");
        jobMapper.update(job);
        jobTask.remove(job);
        jobTask.startJob(job);
    }

    @Override
    public void deleteTemplate(String id) {
        Template template = fetchById(id);
//        SysJob job = new SysJob();
//        job.setJobuid(template.getUuid());
//        jobTask.remove(job);
//        job.setStatus("0");
//        jobMapper.update(job);
        JSONObject data = JSONObject.parseObject(JSONObject.toJSONString(template));
        JSONObject result = new JSONObject();
        result.put("status","0");
        result.put("data",data);
        Jedis jedis = jedisPool.getResource();
        jedis.publish("job_listener",result.toJSONString());
        jedis.close();
//        templateMapper.delete(id);
    }
}
