package com.cftech.brand.category.service.impl;

import com.cftech.brand.category.model.BrandCategory;
import com.cftech.brand.category.dao.BrandCategoryMapper;
import com.cftech.brand.category.service.BrandCategoryService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 分类ServiceImpl
*
* @author faye
* @date 2020/01/14
*/
@Service("brandCategoryService")
public class BrandCategoryServiceImpl extends GenericServiceImpl<BrandCategory> implements BrandCategoryService {

@Autowired
@Qualifier("brandCategoryMapper")
private BrandCategoryMapper brandCategoryMapper;

@Override
public GenericDao<BrandCategory> getGenericMapper() {
return brandCategoryMapper;
}

    @Override
    public List<BrandCategory> fetchSearchByPageVo(Conds conds, Sort sort, int pageNo, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", pageNo > 0 ? pageNo : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return brandCategoryMapper.fetchSearchByPageVo(params);
    }

    @Override
    public List<BrandCategory> fetchSearchByPage(String departmentId, Conds conds, Sort sort, int pageNo, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", pageNo > 0 ? pageNo : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        if(StringUtils.isNotBlank(departmentId)){
            params.put("departmentId", departmentId);
        }
        return brandCategoryMapper.fetchSearchByPage(params);
    }
}