var video = (function () {
    'use strict';
    var Video = function (params) {
        var p = this;
        p.params = {
            appid: '',
            id: '',
            accountsId: '',
            cfApp: null,
            devMode: false,
            localStorage: [],
            dataApi: G.baseUri() + '/mobile/auth/appform/getSvideo',
            vt: ''
        };
        for (var param in params) {
            p.params[param] = params[param];
        }
        var cfApp = p.params.cfApp;

        if (p.params.devMode) {

        }
        p.pageSize = 10;
        p.pageNo = 0;
        p.channelData = [];
        /**
         * 判断app字段
         * @returns 是否app有值
         */
        var validAppField = function () {
            if (!p.params.appid || p.params.appid == '') {
                return false;
            } else {
                return true;
            }
        };

        /**
         * 确认初始化的app 和tokenId 两个值是否都存在
         * 如果不存在则获取一次,获取不到则初始化失败
         * @returns 初始化基础字段是否成功
         */
        var initBaseFields = function () {
            if (!validAppField()) {
                p.params.appid = cfApp.getQueryString('appid');
                p.params.id = cfApp.getQueryString('id');
                p.params.accountsId = cfApp.getQueryString('accountsId');
            }



            //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
            if (!validAppField()) {
                if (p.params.cfApp) {
                    p.params.appid = cfApp.getAppId();
                    //p.params.tokenId = cfApp.getTokenId();
                }
            }
            p.empInfo = cfApp.getMpInfo();
            p.params.accountsId = p.empInfo.accountsId;
            return validAppField();
        };

        /**
         * 初始化组件
         * @returns {boolean}
         */


        p.init = function () {
            if (initBaseFields()) {
                loadData();
                next();
                return true;
            } else {
                return false;
            }
            log();
        };

        var log = function () {
            var formdata = {
                openid: p.empInfo.openId,
                module: "展厅申请",
                modulename: "服务简介",
                keyword: "服务简介",
                keywordid: '',
                vt: new Date().getTime(),
                appid: cfApp.getQueryString('appid'),
                url: location.href
            };
            G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


            });
        }



        var next = function () {
            $(".foot").click(function(){
               location.href="./list.html?appid="+p.params.appid;
            })
        }
        var loadData = function () {
            var formdata = {};
            G.ajax('post', p.params.dataApi, formdata, function (retdata) {
                if(retdata.errorNo=='0'){
                    retdata = retdata.data;
                    retdata.issrc = false;
                    retdata.isspeech = false;
                    retdata.isperson = false;
                    if(retdata.name!=null && retdata.name!=''){
                        retdata.issrc = true;
                    }
                    if(retdata.personContent !=null && retdata.personContent !=''){
                        retdata.isperson = true;
                    }
                    var content = $('#detail-template').html();
                    p.template = Handlebars.compile(content);
                    var htmlStr = p.template(retdata);
                    $('#detail').append(htmlStr);
                    $("#content").html(retdata.personContent);
                    $("#speechContent").html(retdata.speechContent);
                }
            })
        }


    };

    return Video;
})();
