package com.cftech.workshop.album.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.workshop.album.model.Album;
import com.cftech.workshop.album.dao.AlbumMapper;
import com.cftech.workshop.album.model.AlbumDto;
import com.cftech.workshop.album.service.AlbumService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ServiceImpl
 *
 * @author byj
 * @date: 2018-06-29 15:06
 */
@Service("albumService")
public class AlbumServiceImpl extends GenericServiceImpl<Album> implements AlbumService {

    @Autowired
    @Qualifier("albumMapper")
    private AlbumMapper albumMapper;

    @Override
    public GenericDao<Album> getGenericMapper() {
        return albumMapper;
    }

    @Override
    public List<AlbumDto> slelectcountalbumpic(Conds conds , Sort sort, int page, int pagesize){
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pagesize > 0 ? pagesize : 0);
        params.put("sort", sort);
        return albumMapper.slelectcountalbumpic(params);
    }

}