package com.cftech.showroom.appform.service;

import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.showroom.appform.model.AppForm;
import com.cftech.core.generic.GenericService;
import com.cftech.showroom.appform.model.AppFormCalendarDto;
import com.cftech.showroom.appform.model.AppFormVo;
import com.cftech.showroom.appform.model.ShowRoomRecord;

import java.util.List;
import java.util.Map;

/**
 * 展厅申请单Service
 *
 * @author lisw
 * @date: 2019-07-31 15:40
 */
public interface AppFormService extends GenericService<AppForm> {

    Integer isAppointment(String beginTime, String endTime);

    List<AppForm> fetchSearchByPage(Conds var1, Sort var2, int var3, int var4, String beginTime, String endTime);

    List<AppFormVo> fetchSearchByPageForList(Conds var1, Sort var2, int var3, int var4, String beginTime, String endTime);


    List<AppForm> fetchSearchByPageMobile(Conds var1, Sort var2, int var3, int var4);

    List<AppFormCalendarDto> getCalendar(Conds conds);

    List<ShowRoomRecord> getRecordList(Map<String,Object> params);

    List<String> fetchGetName(Map<String,Object> params);
}
