package com.cftech.brand.apply.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.brand.apply.detail.dao.BrandApplyDetailMapper;
import com.cftech.brand.apply.detail.model.BrandApplyDetail;
import com.cftech.brand.apply.model.BrandApply;
import com.cftech.brand.apply.dao.BrandApplyMapper;
import com.cftech.brand.apply.model.BrandApplyVo;
import com.cftech.brand.apply.service.BrandApplyService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 品牌申请ServiceImpl
 *
 * @author faye
 * @date 2020/01/14
 */
@Service("brandApplyService")
public class BrandApplyServiceImpl extends GenericServiceImpl<BrandApply> implements BrandApplyService {

    @Autowired
    @Qualifier("brandApplyMapper")
    private BrandApplyMapper brandApplyMapper;

    @Autowired
    private BrandApplyDetailMapper detailMapper;

    @Override
    public GenericDao<BrandApply> getGenericMapper() {
        return brandApplyMapper;
    }

    @Override
    public List<BrandApplyVo> getApplyData(String openId,Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        if(StringUtils.isNotBlank(openId)){
            params.put("openId",openId);
        }
        return brandApplyMapper.getApplyData(params);
    }

    @Override
    public List<BrandApplyVo> fetchSearchByPageVo(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return brandApplyMapper.fetchSearchByPageVo(params);
    }

    @Override
    public int countVo(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return brandApplyMapper.countVo(params);
    }

    @Override
    public void saveData(BrandApply brandApply, JSONArray detailArr){
        brandApplyMapper.save(brandApply);
        for(int i=0,j=detailArr.size();i<j;i++){
            JSONObject detailObj=detailArr.getJSONObject(i);
            BrandApplyDetail detail=new BrandApplyDetail();
            detail.setAccountsId(brandApply.getAccountsId());
            detail.setApplyId(brandApply.getId());
            detail.setMaterialId(detailObj.getLong("materialId"));
            detail.setQuantity(detailObj.getIntValue("count"));
            detailMapper.save(detail);
        }
    }
}