package com.cftech.qy.qyagent.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.qy.qyagent.dao.QyagentMapper;
import com.cftech.qy.qyagent.model.Qyagent;
import com.cftech.qy.qyagent.service.QyagentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 企业应用管理ServiceImpl
 *
 * @author Neil
 * @date: 2017-04-26 15:02
 */
@Service("qyagentService")
public class QyagentServiceImpl extends GenericServiceImpl<Qyagent> implements QyagentService {

    @Autowired
    @Qualifier("qyagentMapper")
    private QyagentMapper qyagentMapper;

    @Override
    public GenericDao<Qyagent> getGenericMapper() {
        return qyagentMapper;
    }


    @Override
    public void changeStatus(String status, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("status", status);
        qyagentMapper.batchUpdate(params);
    }
}