package org.mp.api.wxmenu;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.req.WeiXinReqService;
import org.mp.api.core.req.model.menu.*;
import org.mp.api.core.req.model.menu.config.CustomWeixinButtonConfig;
import org.mp.api.core.req.model.menu.config.WeixinButtonExtend;
import org.mp.api.core.util.WeiXinConstant;
import org.mp.api.extend.CustomJsonConfig;
import org.mp.api.wxsendmsg.model.WxArticleConfig;

import java.util.ArrayList;
import java.util.List;

/**
 * 微信--menu
 * 
 * @author lizr
 * 
 */
public class JwMenuAPI {

	/**
	 * 创建菜单
	 *  button	是	一级菜单数组，个数应为1~3个
		sub_button	否	二级菜单数组，个数应为1~5个
		type	是	菜单的响应动作类型
		name	是	菜单标题，不超过16个字节，子菜单不超过40个字节
		key	click等点击类型必须	菜单KEY值，用于消息接口推送，不超过128字节
		url	view类型必须	网页链接，用户点击菜单可打开链接，不超过256字节
	 * @param accessToken
	 * @param button  的json字符串
	 * @throws WexinReqException
	 */
	public static String createMenu(String accessToken,List<WeixinButton> button) throws WexinReqException{
		MenuCreate m = new MenuCreate();
		m.setAccess_token(accessToken);
		m.setButton(button);
		JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(m);
		Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
		String msg = "";
		if(error == null){
			msg = result.getString("groupid");
		}else{
			msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
		}
		return msg;
	}
	
	/**
	 * 获取所有的菜单
	 * @param accessToken
	 * @return
	 * @throws WexinReqException
	 */
	public static List<WeixinButton> getAllMenu(String accessToken) throws WexinReqException{
		MenuGet g = new MenuGet();
		g.setAccess_token(accessToken);
		JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(g);
		Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
		List<WeixinButton> lstButton = null;
		JSONObject menu = result.getJSONObject("menu");
		JSONArray buttons = menu.getJSONArray("button");
		JSONArray subButtons = null;
		lstButton = new ArrayList<WeixinButton>();
		WeixinButton btn = null;
		WeixinButton subBtn = null;
		List<WeixinButton> lstSubButton = null;
		for (int i = 0; i < buttons.size(); i++) {
			btn = (WeixinButton) JSONObject.toBean(buttons.getJSONObject(i),
					WeixinButton.class);
			subButtons = buttons.getJSONObject(i).getJSONArray("sub_button");
			if (subButtons != null) {
				lstSubButton = new ArrayList<WeixinButton>();
				for (int j = 0; j < subButtons.size(); j++) {
					subBtn = (WeixinButton) JSONObject.toBean(
							subButtons.getJSONObject(j), WeixinButton.class);
					lstSubButton.add(subBtn);
				}
				btn.setSub_button(lstSubButton);
			}
			lstButton.add(btn);
		}
		return lstButton;
	}
	
	/**
	 * 删除所有的菜单
	 * @param accessToken
	 * @return
	 * @throws WexinReqException
	 */
	public static String deleteMenu(String accessToken) throws WexinReqException{
		MenuDelete m = new MenuDelete();
		m.setAccess_token(accessToken);
		JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(m);
		String msg = result.getString(WeiXinConstant.RETURN_ERROR_INFO_MSG);
		return msg;
	}
	
	//update-begin--Author:luobaoli  Date:20150714 for：增加“获取自定义菜单配置接口”功能接口
	//update-begin--Author:luobaoli  Date:20150715 for：优化该方法的处理逻辑
	/**
	 * 获取自定义接口配置
	 * @param accessToken
	 * @return
	 * @throws WexinReqException
	 */
	public static CustomWeixinButtonConfig getAllMenuConfigure(String accessToken) throws WexinReqException{
		MenuConfigureGet cmcg = new MenuConfigureGet();
		cmcg.setAccess_token(accessToken);
		JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(cmcg);
		Object error = result.get(WeiXinConstant.RETURN_ERROR_INFO_CODE);
		
		CustomWeixinButtonConfig customWeixinButtonConfig = (CustomWeixinButtonConfig) JSONObject.toBean(result, new CustomJsonConfig(CustomWeixinButtonConfig.class,"selfmenu_info"));
		
		JSONObject selfmenuInfo = result.getJSONObject("selfmenu_info");
		if(selfmenuInfo!=null && !JSONUtils.isNull(selfmenuInfo)){ 
			/**处理父类菜单 */
			JSONArray buttons = selfmenuInfo.getJSONArray("button");
			List<WeixinButtonExtend> listButton = new ArrayList<WeixinButtonExtend>();
			for(int i=0;i<buttons.size();i++){
				WeixinButtonExtend weixinButtonExtend = (WeixinButtonExtend) JSONObject.toBean(buttons.getJSONObject(i),new CustomJsonConfig(WeixinButtonExtend.class,"sub_button"));
				/**处理子类菜单 */
				JSONObject subButtonJsonObj = buttons.getJSONObject(i).getJSONObject("sub_button");
				if(subButtonJsonObj!=null && !JSONUtils.isNull(subButtonJsonObj)){
					JSONArray subButtons = subButtonJsonObj.getJSONArray("list");
					if (subButtons != null) {
						List<WeixinButtonExtend> listSubButton = new ArrayList<WeixinButtonExtend>();
						for (int j = 0; j < subButtons.size(); j++) {
							WeixinButtonExtend subBtn = (WeixinButtonExtend) JSONObject.toBean(subButtons.getJSONObject(j), new CustomJsonConfig(WeixinButtonExtend.class,"news_info"));
							/**处理菜单关联的图文消息 */
							JSONObject newsInfoJsonObj = subButtons.getJSONObject(j).getJSONObject("news_info");
							if(newsInfoJsonObj!=null && !JSONUtils.isNull(newsInfoJsonObj)){
								JSONArray newsInfos = newsInfoJsonObj.getJSONArray("list");
								List<WxArticleConfig> listNewsInfo = new ArrayList<WxArticleConfig>();
								for (int k = 0; k < newsInfos.size(); k++) {
									WxArticleConfig wxArticleConfig = (WxArticleConfig) JSONObject.toBean(newsInfos.getJSONObject(k), WxArticleConfig.class);
									listNewsInfo.add(wxArticleConfig);
								}
								subBtn.setNews_info(listNewsInfo);
							}
							listSubButton.add(subBtn);
						}
						weixinButtonExtend.setSub_button(listSubButton);
					}
				}
				listButton.add(weixinButtonExtend);
			}
			customWeixinButtonConfig.setSelfmenu_info(listButton);
		}
		return customWeixinButtonConfig;
	}
	//update-end--Author:luobaoli  Date:20150715 for：优化该方法的处理逻辑
	//update-end--Author:luobaoli  Date:20150714 for：增加“获取自定义菜单配置接口”功能接口
	
	public static void main(String[] args){
		String s="";
		try {
			s = "F41DNE9AWI6X4HsBBF_K9vv__04PHjIZX-kvPNKuZ3jNjsRTh7Wnv-5wOgI_88U1CdVonZeEpwZ3X1sLvJe9iZ2KSpKMVS2uFNw92IqKaTM2LFb2rsowFK8ufXfNE_YrJKQiAGAPQW";
			//s = JwTokenAPI.getAccessToken("wx00737224cb9dbc7d","b9479ebdb58d1c6b6efd4171ebe718b5");
			//s = JwTokenAPI.getAccessToken("wxa53abdf500a8ee6d","2b5dcab55b3dfd1817b33ecfe97cfab7");
			System.out.println(s);
			List<WeixinButton> sub_button = new ArrayList<WeixinButton>();
			List<WeixinButton> sub_button2 = new ArrayList<WeixinButton>();
			List<WeixinButton> sub_button3 = new ArrayList<WeixinButton>();
			
			List<WeixinButton> testsUb = new ArrayList<WeixinButton>();
			WeixinButton w = new WeixinButton();
			w.setName("产品选购");
			
			WeixinButton sub_w_1 = new WeixinButton();
			sub_w_1.setName("新品推荐");
			sub_w_1.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/newproducts/newproducts.html?appid=wx6c1fa6673a17c2d8");
			sub_w_1.setType("view");
			sub_button.add(sub_w_1);
			
			WeixinButton sub_w_2 = new WeixinButton(); 
			sub_w_2.setName("附近门店");
			sub_w_2.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/store/map.html?appid=wx6c1fa6673a17c2d8");
			sub_w_2.setType("view");
			sub_button.add(sub_w_2);
			
			WeixinButton sub_w_3 = new WeixinButton();
			sub_w_3.setName("最新活动");
			sub_w_3.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/activity/activityList.html?appid=wx6c1fa6673a17c2d8");
			sub_w_3.setType("view");
			sub_button.add(sub_w_3);
			WeixinButton w2 = new WeixinButton();
			w2.setName("服务中心");
			WeixinButton sub_w2_1 = new WeixinButton();
			sub_w2_1.setName("预约及进度");
			sub_w2_1.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/oauth2.html?appid=wx6c1fa6673a17c2d8&redirect=http%3a%2f%2fcrmwxfw.hotwater.com.cn%2fdebug%2findex.html%23%2fhome%2fhome%3fappName%3dAomis%26type%3d1");
			sub_w2_1.setType("view");
			sub_button2.add(sub_w2_1);		
			WeixinButton sub_w2_2 = new WeixinButton();
			sub_w2_2.setName("服务评价");
			sub_w2_2.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/oauth2.html?appid=wx6c1fa6673a17c2d8&redirect=http%3a%2f%2fcrmwxfw.hotwater.com.cn%2fdebug%2findex.html%23%2fserviceEvaluation%2flist%3fappName%3dAomis");
			sub_w2_2.setType("view");
			sub_button2.add(sub_w2_2);		
			WeixinButton sub_w2_3 = new WeixinButton();
			sub_w2_3.setName("净水管家");
			sub_w2_3.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/oauth2.html?appid=wx6c1fa6673a17c2d8&redirect=http%3a%2f%2fcrmwxfw.hotwater.com.cn%2fdebug%2findex.html%23%2fhome%2fhome%3fappName%3dAomis%26type%3d2");
			sub_w2_3.setType("view");
			sub_button2.add(sub_w2_3);
			
			WeixinButton sub_w2_4 = new WeixinButton();
			sub_w2_4.setName("空净管家");
			sub_w2_4.setUrl("http://www.baidu.com");
			sub_w2_4.setType("view");
			sub_button2.add(sub_w2_4);
			
			WeixinButton sub_w2_5 = new WeixinButton();
			sub_w2_5.setName("常见问题");
			sub_w2_5.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/oauth2.html?appid=wx6c1fa6673a17c2d8&redirect=http%3a%2f%2fcrmwxfw.hotwater.com.cn%2fdebug%2findex.html%23%2fhome%2fhome%3fappName%3dAomis%26type%3d4");
			sub_w2_5.setType("view");
			sub_button2.add(sub_w2_5);
			
			WeixinButton w3 = new WeixinButton();
			w3.setName("我的艾欧");			
			WeixinButton sub_w3_1 = new WeixinButton();
			sub_w3_1.setName("公司介绍");
			sub_w3_1.setUrl("http://m.aosmith.com.cn/aosmith/history_brand_introduction.jsp");
			sub_w3_1.setType("view");
			sub_button3.add(sub_w3_1);
			WeixinButton sub_w3_2 = new WeixinButton();
			sub_w3_2.setName("加入艾欧");
			sub_w3_2.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/putWe/index.html");
			sub_w3_2.setType("view");
			sub_button3.add(sub_w3_2);
			
			WeixinButton sub_w3_3 = new WeixinButton();
			sub_w3_3.setName("个人中心");
			sub_w3_3.setUrl("http://testmoawx.hotwater.com.cn/cfwechat/static/personCenter/personCenter.html?appid=wx6c1fa6673a17c2d8&registertype=registertype");
			sub_w3_3.setType("view");
			sub_button3.add(sub_w3_3);
			
			w.setSub_button(sub_button);
			w2.setSub_button(sub_button2);
			w3.setSub_button(sub_button3);
			testsUb.add(w);
			testsUb.add(w2);
			testsUb.add(w3);
			//s = getMenuButtonJson("button",b);
			/*Gson gson = new Gson();
			System.out.println(json);*/
			s= JwMenuAPI.createMenu(s,testsUb);
			System.out.println(s);
		} catch (WexinReqException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
//	public static void main(String[] args) {
//		IndustryTemplateMessageSend send = new IndustryTemplateMessageSend();
//		TemplateMessage message = new TemplateMessage();
//		TemplateData first = new TemplateData();
//		first.setValue("恭喜恭喜恭喜你啊");
//		first.setColor("#173177");
//		TemplateData data1 = new TemplateData();
//		data1.setValue("巧克力");
//		data1.setColor("#173177");
//		TemplateData data2 = new TemplateData();
//		data2.setValue("39.8元");
//		data2.setColor("#173177");
//		TemplateData data3 = new TemplateData();
//		data3.setValue("2014年9月22日");
//		data3.setColor("#173177");
//		TemplateData remarks = new TemplateData();
//		remarks.setValue("欢迎再次购买！");
//		remarks.setColor("#173177");
//		send.setAccess_token("rvOLsTzSfePU7fTXj327mEfgOzACaA1YMqaxLUndEBFzwR4pCljcxuyZ0ln3KxrPTfl5EQ_xrd_UjJQWEIoDU8Pxvr8_QoxbK67aHTD36OIh2qb88wcq7xtqZr62LqO1SHMaAIAYNS");
//		send.setTemplate_id("IqaZvD1XGbGHrJBNKUUzfuW2a_-6wxdHrgiV0lDad-k");
//		send.setTopcolor("#173177");
//		message.setFirst(first);
//		message.setKeynote1(data1);
//		message.setKeynote2(data2);
//		message.setKeynote3(data3);
//		message.setRemark(remarks);
//		send.setData(message);
//		send.setUrl("http://www.baidu.com");
//		send.setTouser("oUl3rs0f32nzyel9c72MtnWHQprI");
//		try { 
//			JwTemplateMessageAPI.sendTemplateMsg(send);
//		} catch (WexinReqException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//	}
	
}
