package com.cftech.member.service;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.feature.orm.mybatis.Page;
import com.cftech.core.generic.GenericService;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.member.model.Member;
import com.cftech.member.model.MemberDto;
import com.cftech.member.model.MemberVO;
import com.cftech.workshop.meeting.model.Meeting;

import java.util.List;
import java.util.Map;

/**
* Service
*
* @author lisw
* @date: 2017-08-24 17:31
*/
public interface MemberService extends GenericService<Member> {
    /**
     * 分页查询
     *
     * @param conds    条件
     * @param sort     排序
     * @param page     起始条数
     * @param pageSize 分页大小
     * @return
     */
    List<Member> fetchSearchByPageServer(Conds conds, Sort sort, int page, int pageSize);


    /**
     * 查询总条数
     *
     * @param conds 条件
     * @return 条数
     */
    int countServer(Conds conds);

    void updateworkshop(Member member,String invitcode);

    List<MemberDto> selectmemberDto(Conds conds, Sort sort, int page, int pageSize);

    int selectmemberDtoCount (Conds conds);
    /**
     *
     * 个人信息回填
     *
     * @Param
     * @return
     **/
    JSONObject memberFormation(String openid, String appId);

    /**
     * 个人信息修改
     * @Param
     * @return
     **/
    JSONObject updateMember(MemberVO memberVO);
    /**
     * 个人中心用户信息
     * @Param
     * @return
     **/
    JSONObject fanssChat(String openid,String appId);
}
